/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.nested;

import io.skylite.common.collect.Tuple;
import io.skylite.core.aggregations.AbstractAggregationBuilder;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.NestedScope;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregatorFactory;
import org.opensearch.search.aggregations.bucket.nested.ReverseNestedAggregator;
import org.opensearch.search.aggregations.bucket.nested.ReverseNestedAggregatorFactory;

public class ReverseNestedAggregationBuilder
extends AbstractAggregationBuilder<ReverseNestedAggregationBuilder> {
    public static final String NAME = "reverse_nested";
    private String path;

    public ReverseNestedAggregationBuilder(String name) {
        super(name);
    }

    public ReverseNestedAggregationBuilder(ReverseNestedAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> map) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, map);
        this.path = clone.path;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new ReverseNestedAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public ReverseNestedAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.path = in.readOptionalString();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.path);
    }

    public ReverseNestedAggregationBuilder path(String path) {
        if (path == null) {
            throw new IllegalArgumentException("[path] must not be null: [" + this.name + "]");
        }
        this.path = path;
        return this;
    }

    public String path() {
        return this.path;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        if (ReverseNestedAggregationBuilder.findNestedAggregatorFactory(parent) == null) {
            throw new IllegalArgumentException("Reverse nested aggregation [" + this.name + "] can only be used inside a [nested] aggregation");
        }
        ObjectMapper parentObjectMapper = null;
        if (this.path != null) {
            parentObjectMapper = context.getObjectMapper(this.path);
            if (parentObjectMapper == null) {
                return new ReverseNestedAggregatorFactory(this.name, true, null, context, parent, subFactoriesBuilder, this.metadata);
            }
            if (!parentObjectMapper.isNested()) {
                throw new AggregationExecutionException("[reverse_nested] nested path [" + this.path + "] is not nested");
            }
        }
        NestedScope nestedScope = context.nestedScope();
        NestedObjectMapper nestedMapper = (NestedObjectMapper)parentObjectMapper;
        try {
            nestedScope.nextLevel(nestedMapper);
            ReverseNestedAggregatorFactory reverseNestedAggregatorFactory = new ReverseNestedAggregatorFactory(this.name, false, nestedMapper, context, parent, subFactoriesBuilder, this.metadata);
            return reverseNestedAggregatorFactory;
        }
        finally {
            nestedScope.previousLevel();
        }
    }

    private static NestedAggregatorFactory findNestedAggregatorFactory(AggregatorFactory parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof NestedAggregatorFactory) {
            return (NestedAggregatorFactory)parent;
        }
        return ReverseNestedAggregationBuilder.findNestedAggregatorFactory(parent.getParent());
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.path != null) {
            builder.field(ReverseNestedAggregator.PATH_FIELD.getPreferredName(), this.path);
        }
        builder.endObject();
        return builder;
    }

    public static ReverseNestedAggregationBuilder parse(XContentParser parser, String aggregationName) throws IOException {
        return ReverseNestedAggregationBuilder.parse(aggregationName, parser);
    }

    public static ReverseNestedAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String path = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("path".equals(currentFieldName)) {
                    path = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " in [" + aggregationName + "].", new Object[0]);
        }
        ReverseNestedAggregationBuilder factory = new ReverseNestedAggregationBuilder(aggregationName);
        if (path != null) {
            factory.path(path);
        }
        return factory;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ReverseNestedAggregationBuilder other = (ReverseNestedAggregationBuilder)((Object)obj);
        return Objects.equals(this.path, other.path);
    }

    public String getType() {
        return NAME;
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return ReverseNestedAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return ReverseNestedAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalReverseNested::new));
        }

        public ContextParser<String, ReverseNestedAggregationBuilder> getParser() {
            return ReverseNestedAggregationBuilder::parse;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return null;
        }
    }
}

