/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.nested;

import io.skylite.core.ParseField;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.bucket.SingleBucketAggregator;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.nested.InternalReverseNested;

public class ReverseNestedAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    private final Query parentFilter;
    private final BitSetProducer parentBitsetProducer;

    public ReverseNestedAggregator(String name, AggregatorFactories factories, NestedObjectMapper objectMapper, SearchExecutionContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality, metadata);
        this.parentFilter = objectMapper == null ? Queries.newNonNestedFilter() : objectMapper.nestedTypeFilter();
        this.parentBitsetProducer = context.bitsetFilterCache().getBitSetProducer(this.parentFilter);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final BitSet parentDocs = this.parentBitsetProducer.getBitSet(ctx);
        if (parentDocs == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final HashMap bucketOrdToLastCollectedParentDoc = new HashMap(32);
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int childDoc, long bucket) throws IOException {
                int parentDoc = parentDocs.nextSetBit(childDoc);
                assert (childDoc <= parentDoc && parentDoc != Integer.MAX_VALUE);
                Integer lastCollectedParentDoc = (Integer)bucketOrdToLastCollectedParentDoc.get(bucket);
                if (lastCollectedParentDoc != null) {
                    if (parentDoc > lastCollectedParentDoc) {
                        ReverseNestedAggregator.this.collectBucket(sub, parentDoc, bucket);
                        bucketOrdToLastCollectedParentDoc.put(bucket, parentDoc);
                    }
                } else {
                    ReverseNestedAggregator.this.collectBucket(sub, parentDoc, bucket);
                    bucketOrdToLastCollectedParentDoc.put(bucket, parentDoc);
                }
            }
        };
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalReverseNested(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }

    Query getParentFilter() {
        return this.parentFilter;
    }
}

