/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.range;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.bucket.range.InternalRange;
import org.opensearch.search.aggregations.bucket.range.RangeAggregator;
import org.opensearch.search.aggregations.bucket.range.RangeAggregatorSupplier;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class AbstractRangeAggregatorFactory<R extends RangeAggregator.Range>
extends ValuesSourceAggregatorFactory {
    private final InternalRange.Factory<?, ?> rangeFactory;
    private final R[] ranges;
    private final boolean keyed;
    private final AggregationRegistry.RegistryKey<RangeAggregatorSupplier> registryKey;

    public static void registerAggregators(AggregationRegistry.Builder builder, AggregationRegistry.RegistryKey<RangeAggregatorSupplier> registryKey) {
        builder.register(registryKey, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), RangeAggregator::new, true);
    }

    public AbstractRangeAggregatorFactory(String name, AggregationRegistry.RegistryKey<RangeAggregatorSupplier> registryKey, ValuesSourceConfig config, R[] ranges, boolean keyed, InternalRange.Factory<?, ?> rangeFactory, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.ranges = ranges;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.registryKey = registryKey;
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new RangeAggregator.Unmapped(this.name, this.factories, this.ranges, this.keyed, this.config.format(), searchContext, parent, this.rangeFactory, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((RangeAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(this.registryKey, this.config)).build(this.name, this.factories, (NumericValuesSource)this.config.getValuesSource(), this.config.format(), this.rangeFactory, (RangeAggregator.Range[])this.ranges, this.keyed, searchContext, parent, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

