/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.sampler;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedNumericSamplerAggregator;
import org.opensearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.opensearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class DiversifiedAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int shardSize;
    private final int maxDocsPerValue;
    private final String executionHint;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(DiversifiedAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue, executionHint) -> new DiversifiedNumericSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue), true);
        builder.register(DiversifiedAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.BYTES, (name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue, executionHint) -> {
            SamplerAggregator.ExecutionMode execution = null;
            if (executionHint != null) {
                execution = SamplerAggregator.ExecutionMode.fromString(executionHint);
            }
            if (execution == null) {
                execution = SamplerAggregator.ExecutionMode.GLOBAL_ORDINALS;
            }
            if (execution.needsGlobalOrdinals() && !valuesSourceConfig.hasGlobalOrdinals()) {
                execution = SamplerAggregator.ExecutionMode.MAP;
            }
            return execution.create(name, factories, shardSize, maxDocsPerValue, valuesSourceConfig, context, parent, metadata);
        }, true);
    }

    DiversifiedAggregatorFactory(String name, ValuesSourceConfig config, int shardSize, int maxDocsPerValue, String executionHint, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.shardSize = shardSize;
        this.maxDocsPerValue = maxDocsPerValue;
        this.executionHint = executionHint;
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((DiversifiedAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(DiversifiedAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.shardSize, this.factories, searchContext, parent, metadata, this.config, this.maxDocsPerValue, this.executionHint);
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSampler aggregation = new UnmappedSampler(this.name, metadata);
        return new NonCollectingAggregator(this, this.name, searchContext, parent, this.factories, metadata){

            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

