/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.sampler;

import io.skylite.common.collect.Tuple;
import io.skylite.core.aggregations.AbstractAggregationBuilder;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.sampler.InternalSampler;
import org.opensearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.opensearch.search.aggregations.bucket.sampler.SamplerAggregatorFactory;
import org.opensearch.search.aggregations.bucket.sampler.UnmappedSampler;

public class SamplerAggregationBuilder
extends AbstractAggregationBuilder<SamplerAggregationBuilder> {
    public static final String NAME = "sampler";
    public static final int DEFAULT_SHARD_SAMPLE_SIZE = 100;
    private int shardSize = 100;

    public SamplerAggregationBuilder(String name) {
        super(name);
    }

    protected SamplerAggregationBuilder(SamplerAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.shardSize = clone.shardSize;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new SamplerAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public SamplerAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.shardSize = in.readVInt();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardSize);
    }

    public SamplerAggregationBuilder shardSize(int shardSize) {
        this.shardSize = shardSize;
        return this;
    }

    public int shardSize() {
        return this.shardSize;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    protected SamplerAggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new SamplerAggregatorFactory(this.name, this.shardSize, context, parent, subFactoriesBuilder, this.metadata);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SamplerAggregator.SHARD_SIZE_FIELD.getPreferredName(), this.shardSize);
        builder.endObject();
        return builder;
    }

    public static SamplerAggregationBuilder parse(XContentParser parser, String aggregationName) throws IOException {
        return SamplerAggregationBuilder.parse(aggregationName, parser);
    }

    public static SamplerAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        Integer shardSize = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (SamplerAggregator.SHARD_SIZE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    shardSize = parser.intValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unsupported property \"" + currentFieldName + "\" for aggregation \"" + aggregationName, new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unsupported property \"" + currentFieldName + "\" for aggregation \"" + aggregationName, new Object[0]);
        }
        SamplerAggregationBuilder factory = new SamplerAggregationBuilder(aggregationName);
        if (shardSize != null) {
            factory.shardSize(shardSize);
        }
        return factory;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shardSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SamplerAggregationBuilder other = (SamplerAggregationBuilder)((Object)obj);
        return Objects.equals(this.shardSize, other.shardSize);
    }

    public String getType() {
        return NAME;
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return SamplerAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return SamplerAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Arrays.asList(new Tuple(Optional.of("mapped_sampler"), InternalSampler::new), new Tuple(Optional.of("unmapped_sampler"), UnmappedSampler::new));
        }

        public ContextParser<String, SamplerAggregationBuilder> getParser() {
            return SamplerAggregationBuilder::parse;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return null;
        }
    }
}

