/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.bucket.terms.DoubleTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;

public class LongTerms
extends InternalMappedTerms<LongTerms, Bucket> {
    public static final String NAME = "lterms";

    public LongTerms(String name, BucketOrder reduceOrder, BucketOrder order, Map<String, Object> metadata, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError, TermsAggregator.BucketCountThresholds bucketCountThresholds) {
        super(name, reduceOrder, order, metadata, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError, bucketCountThresholds);
    }

    public LongTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public LongTerms create(List<Bucket> buckets) {
        return new LongTerms(this.name, this.reduceOrder, this.order, (Map<String, Object>)this.metadata, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError, this.bucketCountThresholds);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.format);
    }

    @Override
    protected LongTerms create(String name, List<Bucket> buckets, BucketOrder reduceOrder, long docCountError, long otherDocCount) {
        return new LongTerms(name, reduceOrder, this.order, (Map<String, Object>)this.getMetadata(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError, this.bucketCountThresholds);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        boolean unsignedLongFormat = false;
        boolean rawFormat = false;
        for (InternalAggregation agg : aggregations) {
            if (agg instanceof DoubleTerms) {
                return agg.reduce(aggregations, reduceContext);
            }
            if (!(agg instanceof LongTerms)) continue;
            if (((LongTerms)agg).format == DocValueFormat.RAW) {
                rawFormat = true;
                continue;
            }
            if (((LongTerms)agg).format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                unsignedLongFormat = true;
                continue;
            }
            if (((LongTerms)agg).format != DocValueFormat.UNSIGNED_LONG) continue;
            unsignedLongFormat = true;
        }
        if (rawFormat && unsignedLongFormat) {
            ArrayList<InternalAggregation> newAggs = new ArrayList<InternalAggregation>(aggregations.size());
            for (InternalAggregation agg : aggregations) {
                if (agg instanceof LongTerms) {
                    DoubleTerms dTerms = LongTerms.convertLongTermsToDouble((LongTerms)agg, this.format);
                    newAggs.add(dTerms);
                    continue;
                }
                newAggs.add(agg);
            }
            return ((InternalAggregation)newAggs.get(0)).reduce(newAggs, reduceContext);
        }
        return super.reduce(aggregations, reduceContext);
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, long docCountError, Bucket prototype) {
        return new Bucket(prototype.term, docCount, aggs, prototype.showDocCountError, docCountError, this.format);
    }

    static DoubleTerms convertLongTermsToDouble(LongTerms longTerms, DocValueFormat decimalFormat) {
        List buckets = longTerms.getBuckets();
        ArrayList<DoubleTerms.Bucket> newBuckets = new ArrayList<DoubleTerms.Bucket>();
        for (Terms.Bucket bucket : buckets) {
            newBuckets.add(new DoubleTerms.Bucket(bucket.getKeyAsNumber().doubleValue(), bucket.getDocCount(), (InternalAggregations)bucket.getAggregations(), longTerms.showTermDocCountError, longTerms.showTermDocCountError ? bucket.getDocCountError() : 0L, decimalFormat));
        }
        return new DoubleTerms(longTerms.getName(), longTerms.reduceOrder, longTerms.order, (Map<String, Object>)longTerms.metadata, longTerms.format, longTerms.shardSize, longTerms.showTermDocCountError, longTerms.otherDocCount, (List<DoubleTerms.Bucket>)newBuckets, longTerms.docCountError, longTerms.bucketCountThresholds);
    }

    public static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        long term;

        public Bucket(long term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.term = term;
        }

        public Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.term = in.readLong();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeLong(this.term);
        }

        public String getKeyAsString() {
            return this.format.format(this.term).toString();
        }

        public Object getKey() {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                return this.format.format(this.term);
            }
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                return (Number)this.format.format(this.term);
            }
            return this.term;
        }

        public int compareKey(Bucket other) {
            return Long.compare(this.term, other.term);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.format.format(this.term));
            } else {
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.term);
            }
            if (this.format != DocValueFormat.RAW && this.format != DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.format.format(this.term).toString());
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.term, ((Bucket)obj).term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.term);
        }
    }
}

