/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.BytesRefHash;
import io.skylite.core.common.util.LongArray;
import io.skylite.core.common.util.LongHash;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.lucene.index.FilterableTermsEnum;
import io.skylite.core.mapper.MappedFieldType;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;

class SignificanceLookup {
    private final AggregationContext context;
    private final MappedFieldType fieldType;
    private final DocValueFormat format;
    private final Query backgroundFilter;
    private final int supersetNumDocs;
    private TermsEnum termsEnum;

    SignificanceLookup(AggregationContext context, MappedFieldType fieldType, DocValueFormat format, QueryBuilder backgroundFilter) throws IOException {
        this.context = context;
        this.fieldType = fieldType;
        this.format = format;
        this.backgroundFilter = backgroundFilter == null ? null : context.buildQuery(backgroundFilter);
        IndexSearcher searcher = context.searcher();
        this.supersetNumDocs = backgroundFilter == null ? searcher.getIndexReader().maxDoc() : searcher.count(this.backgroundFilter);
    }

    long supersetSize() {
        return this.supersetNumDocs;
    }

    BackgroundFrequencyForBytes bytesLookup(final BigArrays bigArrays, CardinalityUpperBound cardinality) {
        if (cardinality == CardinalityUpperBound.ONE) {
            return new BackgroundFrequencyForBytes(){

                @Override
                public long freq(BytesRef term) throws IOException {
                    return SignificanceLookup.this.getBackgroundFrequency(term);
                }

                public void close() {
                }
            };
        }
        return new BackgroundFrequencyForBytes(){
            private final BytesRefHash termToPosition;
            private LongArray positionToFreq;
            {
                this.termToPosition = new BytesRefHash(bigArrays);
                this.positionToFreq = bigArrays.newLongArray(1L, false);
            }

            @Override
            public long freq(BytesRef term) throws IOException {
                long position = this.termToPosition.add(term);
                if (position < 0L) {
                    return this.positionToFreq.get(-1L - position);
                }
                long freq = SignificanceLookup.this.getBackgroundFrequency(term);
                this.positionToFreq = bigArrays.grow(this.positionToFreq, position + 1L);
                this.positionToFreq.set(position, freq);
                return freq;
            }

            public void close() {
                Releasables.close((Releasable[])new Releasable[]{this.termToPosition, this.positionToFreq});
            }
        };
    }

    private long getBackgroundFrequency(BytesRef term) throws IOException {
        return this.getBackgroundFrequency(this.context.buildQuery((QueryBuilder)new TermQueryBuilder(this.fieldType.name(), this.format.format(term).toString())));
    }

    BackgroundFrequencyForLong longLookup(final BigArrays bigArrays, CardinalityUpperBound cardinality) {
        if (cardinality == CardinalityUpperBound.ONE) {
            return new BackgroundFrequencyForLong(){

                @Override
                public long freq(long term) throws IOException {
                    return SignificanceLookup.this.getBackgroundFrequency(term);
                }

                public void close() {
                }
            };
        }
        return new BackgroundFrequencyForLong(){
            private final LongHash termToPosition;
            private LongArray positionToFreq;
            {
                this.termToPosition = new LongHash(1L, bigArrays);
                this.positionToFreq = bigArrays.newLongArray(1L, false);
            }

            @Override
            public long freq(long term) throws IOException {
                long position = this.termToPosition.add(term);
                if (position < 0L) {
                    return this.positionToFreq.get(-1L - position);
                }
                long freq = SignificanceLookup.this.getBackgroundFrequency(term);
                this.positionToFreq = bigArrays.grow(this.positionToFreq, position + 1L);
                this.positionToFreq.set(position, freq);
                return freq;
            }

            public void close() {
                Releasables.close((Releasable[])new Releasable[]{this.termToPosition, this.positionToFreq});
            }
        };
    }

    private long getBackgroundFrequency(long term) throws IOException {
        return this.getBackgroundFrequency(this.context.buildQuery((QueryBuilder)new TermQueryBuilder(this.fieldType.name(), this.format.format(term).toString())));
    }

    private long getBackgroundFrequency(Query query) throws IOException {
        if (query instanceof TermQuery) {
            Term term = ((TermQuery)query).getTerm();
            TermsEnum termsEnum = this.getTermsEnum(term.field());
            if (termsEnum.seekExact(term.bytes())) {
                return termsEnum.docFreq();
            }
            return 0L;
        }
        if (this.backgroundFilter != null) {
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(this.backgroundFilter, BooleanClause.Occur.FILTER).build();
        }
        return this.context.searcher().count(query);
    }

    private TermsEnum getTermsEnum(String field) throws IOException {
        if (this.termsEnum != null) {
            return this.termsEnum;
        }
        IndexReader reader = this.context.searcher().getIndexReader();
        this.termsEnum = new FilterableTermsEnum(reader, this.fieldType.name(), 0, this.backgroundFilter);
        return this.termsEnum;
    }

    static interface BackgroundFrequencyForLong
    extends Releasable {
        public long freq(long var1) throws IOException;
    }

    static interface BackgroundFrequencyForBytes
    extends Releasable {
        public long freq(BytesRef var1) throws IOException;
    }
}

