/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.lease.Releasables;
import io.skylite.common.util.ArrayUtils;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.ObjectArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;

abstract class AbstractHDRPercentilesAggregator
extends NumericMetricsAggregator.MultiValue {
    protected final double[] keys;
    protected final ValuesSource valuesSource;
    protected final DocValueFormat format;
    protected ObjectArray<DoubleHistogram> states;
    protected final int numberOfSignificantValueDigits;
    protected final boolean keyed;

    private static int indexOfKey(double[] keys, double key) {
        return ArrayUtils.binarySearch((double[])keys, (double)key, (double)0.001);
    }

    AbstractHDRPercentilesAggregator(String name, ValuesSource valuesSource, SearchExecutionContext context, Aggregator parent, double[] keys, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSource;
        this.keyed = keyed;
        this.format = formatter;
        this.states = context.bigArrays().newObjectArray(1L);
        this.keys = keys;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = ((NumericValuesSource)this.valuesSource).doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                DoubleHistogram state = AbstractHDRPercentilesAggregator.this.getExistingOrNewHistogram(bigArrays, bucket);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    for (int i = 0; i < valueCount; ++i) {
                        state.recordValue(values.nextValue());
                    }
                }
            }
        };
    }

    private DoubleHistogram getExistingOrNewHistogram(BigArrays bigArrays, long bucket) {
        this.states = bigArrays.grow(this.states, bucket + 1L);
        DoubleHistogram state = (DoubleHistogram)this.states.get(bucket);
        if (state == null) {
            state = new DoubleHistogram(this.numberOfSignificantValueDigits);
            state.setAutoResize(true);
            this.states.set(bucket, (Object)state);
        }
        return state;
    }

    @Override
    public boolean hasMetric(String name) {
        return AbstractHDRPercentilesAggregator.indexOfKey(this.keys, Double.parseDouble(name)) >= 0;
    }

    protected DoubleHistogram getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        DoubleHistogram state = (DoubleHistogram)this.states.get(bucketOrd);
        return state;
    }

    @Override
    protected void doClose() {
        Releasables.close(this.states);
    }
}

