/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.Version;
import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.metrics.CardinalityAggregatorFactory;
import org.opensearch.search.aggregations.metrics.CardinalityAggregatorSupplier;
import org.opensearch.search.aggregations.metrics.InternalCardinality;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public final class CardinalityAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource, CardinalityAggregationBuilder> {
    public static final String NAME = "cardinality";
    public static final AggregationRegistry.RegistryKey<CardinalityAggregatorSupplier> REGISTRY_KEY = new AggregationRegistry.RegistryKey("cardinality", CardinalityAggregatorSupplier.class);
    private static final ParseField REHASH = new ParseField("rehash", new String[0]).withAllDeprecated("no replacement - values will always be rehashed");
    public static final ParseField PRECISION_THRESHOLD_FIELD = new ParseField("precision_threshold", new String[0]);
    public static final ObjectParser<CardinalityAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"cardinality", CardinalityAggregationBuilder::new);
    private Long precisionThreshold = null;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        CardinalityAggregatorFactory.registerAggregators(builder);
    }

    public CardinalityAggregationBuilder(String name) {
        super(name);
    }

    public CardinalityAggregationBuilder(CardinalityAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.precisionThreshold = clone.precisionThreshold;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    public CardinalityAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.precisionThreshold = in.readLong();
        }
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new CardinalityAggregationBuilder(this, factoriesBuilder, metadata);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        boolean hasPrecisionThreshold = this.precisionThreshold != null;
        out.writeBoolean(hasPrecisionThreshold);
        if (hasPrecisionThreshold) {
            out.writeLong(this.precisionThreshold.longValue());
        }
    }

    @Override
    protected boolean serializeTargetValueType(Version version) {
        return true;
    }

    public CardinalityAggregationBuilder precisionThreshold(long precisionThreshold) {
        if (precisionThreshold < 0L) {
            throw new IllegalArgumentException("[precisionThreshold] must be greater than or equal to 0. Found [" + precisionThreshold + "] in [" + this.name + "]");
        }
        this.precisionThreshold = precisionThreshold;
        return this;
    }

    public Long precisionThreshold() {
        return this.precisionThreshold;
    }

    @Override
    protected CardinalityAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new CardinalityAggregatorFactory(this.name, config, this.precisionThreshold, context, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.precisionThreshold != null) {
            builder.field(PRECISION_THRESHOLD_FIELD.getPreferredName(), this.precisionThreshold);
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precisionThreshold);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CardinalityAggregationBuilder other = (CardinalityAggregationBuilder)((Object)obj);
        return Objects.equals(this.precisionThreshold, other.precisionThreshold);
    }

    public String getType() {
        return NAME;
    }

    @Override
    protected AggregationRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, false, false);
        PARSER.declareLong(CardinalityAggregationBuilder::precisionThreshold, PRECISION_THRESHOLD_FIELD);
        PARSER.declareLong((b, v) -> {}, REHASH);
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.METRIC;
        }

        public String getName() {
            return CardinalityAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return CardinalityAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalCardinality::new));
        }

        public ContextParser<String, CardinalityAggregationBuilder> getParser() {
            return PARSER;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return CardinalityAggregationBuilder::registerAggregators;
        }
    }
}

