/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.Nullable;
import io.skylite.common.hash.MurmurHash3;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.util.BitMixer;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.BitArray;
import io.skylite.core.common.util.LongArray;
import io.skylite.core.common.util.ObjectArray;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.opensearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.opensearch.search.aggregations.metrics.InternalCardinality;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;

public class CardinalityAggregator
extends NumericMetricsAggregator.SingleValue {
    private final int precision;
    private final ValuesSource valuesSource;
    @Nullable
    private HyperLogLogPlusPlus counts;
    private Collector collector;
    private int emptyCollectorsUsed;
    private int numericCollectorsUsed;
    private int ordinalsCollectorsUsed;
    private int ordinalsCollectorsOverheadTooHigh;
    private int stringHashingCollectorsUsed;

    public CardinalityAggregator(String name, ValuesSourceConfig valuesSourceConfig, int precision, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? valuesSourceConfig.getValuesSource() : null;
        this.precision = precision;
        this.counts = this.valuesSource == null ? null : new HyperLogLogPlusPlus(precision, context.bigArrays(), 1L);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    private Collector pickCollector(LeafReaderContext ctx) throws IOException {
        if (this.valuesSource == null) {
            ++this.emptyCollectorsUsed;
            return new EmptyCollector();
        }
        if (this.valuesSource instanceof NumericValuesSource) {
            NumericValuesSource source = (NumericValuesSource)this.valuesSource;
            MurmurHash3Values hashValues = source.isFloatingPoint() || source.isBigInteger() ? MurmurHash3Values.hash(source.doubleValues(ctx)) : MurmurHash3Values.hash(source.longValues(ctx));
            ++this.numericCollectorsUsed;
            return new DirectCollector(this.counts, hashValues);
        }
        if (this.valuesSource instanceof BytesValuesSource.WithOrdinals) {
            long countsMemoryUsage;
            BytesValuesSource.WithOrdinals source = (BytesValuesSource.WithOrdinals)this.valuesSource;
            SortedSetDocValues ordinalValues = source.ordinalsValues(ctx);
            long maxOrd = ordinalValues.getValueCount();
            if (maxOrd == 0L) {
                ++this.emptyCollectorsUsed;
                return new EmptyCollector();
            }
            long ordinalsMemoryUsage = OrdinalsCollector.memoryOverhead(maxOrd);
            if (ordinalsMemoryUsage < (countsMemoryUsage = HyperLogLogPlusPlus.memoryUsage(this.precision)) / 4L) {
                ++this.ordinalsCollectorsUsed;
                return new OrdinalsCollector(this.counts, ordinalValues, this.context.bigArrays());
            }
            ++this.ordinalsCollectorsOverheadTooHigh;
        }
        ++this.stringHashingCollectorsUsed;
        return new DirectCollector(this.counts, MurmurHash3Values.hash(this.valuesSource.bytesValues(ctx)));
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        this.postCollectLastCollector();
        this.collector = this.pickCollector(ctx);
        return this.collector;
    }

    private void postCollectLastCollector() throws IOException {
        if (this.collector != null) {
            try {
                this.collector.postCollect();
            }
            finally {
                this.collector.close();
                this.collector = null;
            }
        }
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.postCollectLastCollector();
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.counts == null ? 0.0 : (double)this.counts.cardinality(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.counts == null || owningBucketOrdinal >= this.counts.maxOrd() || this.counts.cardinality(owningBucketOrdinal) == 0L) {
            return this.buildEmptyAggregation();
        }
        AbstractHyperLogLogPlusPlus copy = this.counts.clone(owningBucketOrdinal, BigArrays.NON_RECYCLING_INSTANCE);
        return new InternalCardinality(this.name, copy, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalCardinality(this.name, null, this.metadata());
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.collector});
    }

    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("empty_collectors_used", this.emptyCollectorsUsed);
        add.accept("numeric_collectors_used", this.numericCollectorsUsed);
        add.accept("ordinals_collectors_used", this.ordinalsCollectorsUsed);
        add.accept("ordinals_collectors_overhead_too_high", this.ordinalsCollectorsOverheadTooHigh);
        add.accept("string_hashing_collectors_used", this.stringHashingCollectorsUsed);
    }

    private static class EmptyCollector
    extends Collector {
        private EmptyCollector() {
        }

        public void collect(int doc, long bucketOrd) {
        }

        @Override
        public void postCollect() {
        }

        public void close() {
        }
    }

    static abstract class MurmurHash3Values {
        MurmurHash3Values() {
        }

        public abstract boolean advanceExact(int var1) throws IOException;

        public abstract int count();

        public abstract long nextValue() throws IOException;

        public static MurmurHash3Values hash(SortedNumericDoubleValues values) {
            return new Double(values);
        }

        public static MurmurHash3Values hash(SortedNumericDocValues values) {
            return new Long(values);
        }

        public static MurmurHash3Values hash(SortedBinaryDocValues values) {
            return new Bytes(values);
        }

        private static class Double
        extends MurmurHash3Values {
            private final SortedNumericDoubleValues values;

            Double(SortedNumericDoubleValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                return BitMixer.mix64((long)java.lang.Double.doubleToLongBits(this.values.nextValue()));
            }
        }

        private static class Long
        extends MurmurHash3Values {
            private final SortedNumericDocValues values;

            Long(SortedNumericDocValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                return BitMixer.mix64((long)this.values.nextValue());
            }
        }

        private static class Bytes
        extends MurmurHash3Values {
            private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
            private final SortedBinaryDocValues values;

            Bytes(SortedBinaryDocValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                BytesRef bytes = this.values.nextValue();
                MurmurHash3.hash128((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)this.hash);
                return this.hash.h1;
            }
        }
    }

    private static class DirectCollector
    extends Collector {
        private final MurmurHash3Values hashes;
        private final HyperLogLogPlusPlus counts;

        DirectCollector(HyperLogLogPlusPlus counts, MurmurHash3Values values) {
            this.counts = counts;
            this.hashes = values;
        }

        public void collect(int doc, long bucketOrd) throws IOException {
            if (this.hashes.advanceExact(doc)) {
                int valueCount = this.hashes.count();
                for (int i = 0; i < valueCount; ++i) {
                    this.counts.collect(bucketOrd, this.hashes.nextValue());
                }
            }
        }

        @Override
        public void postCollect() {
        }

        public void close() {
        }
    }

    private static class OrdinalsCollector
    extends Collector {
        private static final long SHALLOW_FIXEDBITSET_SIZE = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
        private final BigArrays bigArrays;
        private final SortedSetDocValues values;
        private final int maxOrd;
        private final HyperLogLogPlusPlus counts;
        private ObjectArray<BitArray> visitedOrds;

        public static long memoryOverhead(long maxOrd) {
            return (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + SHALLOW_FIXEDBITSET_SIZE + (maxOrd + 7L) / 8L;
        }

        OrdinalsCollector(HyperLogLogPlusPlus counts, SortedSetDocValues values, BigArrays bigArrays) {
            if (values.getValueCount() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.maxOrd = (int)values.getValueCount();
            this.bigArrays = bigArrays;
            this.counts = counts;
            this.values = values;
            this.visitedOrds = bigArrays.newObjectArray(1L);
        }

        public void collect(int doc, long bucketOrd) throws IOException {
            this.visitedOrds = this.bigArrays.grow(this.visitedOrds, bucketOrd + 1L);
            BitArray bits = (BitArray)this.visitedOrds.get(bucketOrd);
            if (bits == null) {
                bits = new BitArray((long)this.maxOrd, this.bigArrays);
                this.visitedOrds.set(bucketOrd, (Object)bits);
            }
            if (this.values.advanceExact(doc)) {
                for (int i = 0; i < this.values.docValueCount(); ++i) {
                    long ord = this.values.nextOrd();
                    bits.set((long)((int)ord));
                }
            }
        }

        @Override
        public void postCollect() throws IOException {
            try (BitArray allVisitedOrds = new BitArray((long)this.maxOrd, this.bigArrays);){
                for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                    BitArray bits = (BitArray)this.visitedOrds.get(bucket);
                    if (bits == null) continue;
                    allVisitedOrds.or(bits);
                }
                try (LongArray hashes = this.bigArrays.newLongArray((long)this.maxOrd, false);){
                    MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
                    long ord = allVisitedOrds.nextSetBit(0L);
                    while (ord < Long.MAX_VALUE) {
                        BytesRef value = this.values.lookupOrd(ord);
                        MurmurHash3.hash128((byte[])value.bytes, (int)value.offset, (int)value.length, (long)0L, (MurmurHash3.Hash128)hash);
                        hashes.set(ord, hash.h1);
                        ord = ord + 1L < (long)this.maxOrd ? allVisitedOrds.nextSetBit(ord + 1L) : Long.MAX_VALUE;
                    }
                    for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                        BitArray bits = (BitArray)this.visitedOrds.get(bucket);
                        if (bits == null) continue;
                        long ord2 = bits.nextSetBit(0L);
                        while (ord2 < Long.MAX_VALUE) {
                            this.counts.collect(bucket, hashes.get(ord2));
                            ord2 = ord2 + 1L < (long)this.maxOrd ? bits.nextSetBit(ord2 + 1L) : Long.MAX_VALUE;
                        }
                    }
                }
            }
        }

        public void close() {
            int i = 0;
            while ((long)i < this.visitedOrds.size()) {
                Releasables.close((Releasable)((Releasable)this.visitedOrds.get((long)i)));
                ++i;
            }
            Releasables.close(this.visitedOrds);
        }
    }

    private static abstract class Collector
    extends LeafBucketCollector
    implements Releasable {
        private Collector() {
        }

        public abstract void postCollect() throws IOException;
    }
}

