/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.opensearch.search.aggregations.metrics.AbstractHDRPercentilesAggregator;
import org.opensearch.search.aggregations.metrics.InternalHDRPercentileRanks;

class HDRPercentileRanksAggregator
extends AbstractHDRPercentilesAggregator {
    HDRPercentileRanksAggregator(String name, ValuesSource valuesSource, SearchExecutionContext context, Aggregator parent, double[] percents, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat format, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, numberOfSignificantValueDigits, keyed, format, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        DoubleHistogram state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        DoubleHistogram state = new DoubleHistogram(this.numberOfSignificantValueDigits);
        state.setAutoResize(true);
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        DoubleHistogram state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalHDRPercentileRanks.percentileRank(state, Double.valueOf(name));
    }
}

