/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.opensearch.search.aggregations.metrics.Cardinality;
import org.opensearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.opensearch.search.aggregations.metrics.InternalNumericMetricsAggregation;

public final class InternalCardinality
extends InternalNumericMetricsAggregation.SingleValue
implements Cardinality {
    private final AbstractHyperLogLogPlusPlus counts;

    InternalCardinality(String name, AbstractHyperLogLogPlusPlus counts, Map<String, Object> metadata) {
        super(name, metadata);
        this.counts = counts;
    }

    public InternalCardinality(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.counts = in.readBoolean() ? AbstractHyperLogLogPlusPlus.readFrom(in, BigArrays.NON_RECYCLING_INSTANCE) : null;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        if (this.counts != null) {
            out.writeBoolean(true);
            this.counts.writeTo(0L, out);
        } else {
            out.writeBoolean(false);
        }
    }

    public String getWriteableName() {
        return "cardinality";
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.counts == null ? 0L : this.counts.cardinality(0L);
    }

    public AbstractHyperLogLogPlusPlus getCounts() {
        return this.counts;
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        HyperLogLogPlusPlus reduced = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalCardinality cardinality = (InternalCardinality)aggregation;
            if (cardinality.counts == null) continue;
            if (reduced == null) {
                reduced = new HyperLogLogPlusPlus(cardinality.counts.precision(), BigArrays.NON_RECYCLING_INSTANCE, 1L);
            }
            reduced.merge(0L, cardinality.counts, 0L);
        }
        if (reduced == null) {
            return aggregations.get(0);
        }
        return new InternalCardinality(this.name, reduced, this.getMetadata());
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        long cardinality = this.getValue();
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), cardinality);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.counts.hashCode(0L));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalCardinality other = (InternalCardinality)obj;
        return this.counts.equals(0L, other.counts, 0L);
    }

    AbstractHyperLogLogPlusPlus getState() {
        return this.counts;
    }
}

