/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.Sum;

public class InternalSum
extends InternalNumericMetricsAggregation.SingleValue
implements Sum {
    private final double sum;

    public InternalSum(String name, double sum, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, metadata);
        this.sum = sum;
        this.format = formatter;
    }

    public InternalSum(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.sum = in.readDouble();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeDouble(this.sum);
    }

    public String getWriteableName() {
        return "sum";
    }

    @Override
    public double value() {
        return this.sum;
    }

    @Override
    public double getValue() {
        return this.sum;
    }

    public InternalSum reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        for (InternalAggregation aggregation : aggregations) {
            double value = ((InternalSum)aggregation).sum;
            kahanSummation.add(value);
        }
        return new InternalSum(this.name, kahanSummation.value(), this.format, this.getMetadata());
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.sum);
        if (this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.sum).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sum);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSum that = (InternalSum)obj;
        return Objects.equals(this.sum, that.sum);
    }
}

