/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.DoubleArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.NumericDoubleValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.Bits;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;

class MaxAggregator
extends NumericMetricsAggregator.SingleValue {
    final NumericValuesSource valuesSource;
    final DocValueFormat formatter;
    final String pointField;
    final Function<byte[], Number> pointConverter;
    DoubleArray maxes;

    MaxAggregator(String name, ValuesSourceConfig config, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        NumericValuesSource numericValuesSource = this.valuesSource = config.hasValues() ? (NumericValuesSource)config.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.maxes = context.bigArrays().newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
        this.formatter = config.format();
        this.pointConverter = this.pointReaderIfAvailable(config);
        this.pointField = this.pointConverter != null ? config.fieldContext().field() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        Number segMax;
        if (this.valuesSource == null) {
            if (this.parent != null) {
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
            throw new CollectionTerminatedException();
        }
        if (this.pointConverter != null && (segMax = MaxAggregator.findLeafMaxValue(ctx.reader(), this.pointField, this.pointConverter)) != null) {
            assert (this.maxes.size() == 1L);
            double max = this.maxes.get(0L);
            max = Math.max(max, segMax.doubleValue());
            this.maxes.set(0L, max);
            throw new CollectionTerminatedException();
        }
        final BigArrays bigArrays = this.context.bigArrays();
        SortedNumericDoubleValues allValues = this.valuesSource.doubleValues(ctx);
        final NumericDoubleValues values = MultiValueMode.MAX.select(allValues);
        return new LeafBucketCollectorBase(sub, allValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= MaxAggregator.this.maxes.size()) {
                    long from = MaxAggregator.this.maxes.size();
                    MaxAggregator.this.maxes = bigArrays.grow(MaxAggregator.this.maxes, bucket + 1L);
                    MaxAggregator.this.maxes.fill(from, MaxAggregator.this.maxes.size(), Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    double value = values.doubleValue();
                    double max = MaxAggregator.this.maxes.get(bucket);
                    max = Math.max(max, value);
                    MaxAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.maxes.size()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.maxes.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.maxes.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMax(this.name, this.maxes.get(bucket), this.formatter, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMax(this.name, Double.NEGATIVE_INFINITY, this.formatter, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.maxes);
    }

    static Number findLeafMaxValue(LeafReader reader, String fieldName, Function<byte[], Number> converter) throws IOException {
        PointValues pointValues = reader.getPointValues(fieldName);
        if (pointValues == null) {
            return null;
        }
        final Bits liveDocs = reader.getLiveDocs();
        if (liveDocs == null) {
            return converter.apply(pointValues.getMaxPackedValue());
        }
        final int numBytes = pointValues.getBytesPerDimension();
        final byte[] maxValue = pointValues.getMaxPackedValue();
        final byte[][] result = new byte[1][];
        pointValues.intersect(new PointValues.IntersectVisitor(){

            public void visit(int docID) {
                throw new UnsupportedOperationException();
            }

            public void visit(int docID, byte[] packedValue) {
                if (liveDocs.get(docID)) {
                    if (result[0] == null) {
                        result[0] = new byte[packedValue.length];
                    }
                    System.arraycopy(packedValue, 0, result[0], 0, packedValue.length);
                }
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                if (Arrays.equals(maxValue, 0, numBytes, maxPackedValue, 0, numBytes)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        });
        return result[0] != null ? (Number)converter.apply(result[0]) : (Number)null;
    }
}

