/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.Nullable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.ObjectArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.InternalMedianAbsoluteDeviation;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.opensearch.search.aggregations.metrics.TDigestState;

public class MedianAbsoluteDeviationAggregator
extends NumericMetricsAggregator.SingleValue {
    private final NumericValuesSource valuesSource;
    private final DocValueFormat format;
    private final double compression;
    private ObjectArray<TDigestState> valueSketches;

    MedianAbsoluteDeviationAggregator(String name, @Nullable ValuesSource valuesSource, DocValueFormat format, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata, double compression) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = (NumericValuesSource)valuesSource;
        this.format = Objects.requireNonNull(format);
        this.compression = compression;
        this.valueSketches = context.bigArrays().newObjectArray(1L);
    }

    private boolean hasDataForBucket(long bucketOrd) {
        return bucketOrd < this.valueSketches.size() && this.valueSketches.get(bucketOrd) != null;
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.hasDataForBucket(owningBucketOrd)) {
            return InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation((TDigestState)((Object)this.valueSketches.get(owningBucketOrd)));
        }
        return Double.NaN;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                MedianAbsoluteDeviationAggregator.this.valueSketches = bigArrays.grow(MedianAbsoluteDeviationAggregator.this.valueSketches, bucket + 1L);
                TDigestState valueSketch = (TDigestState)((Object)MedianAbsoluteDeviationAggregator.this.valueSketches.get(bucket));
                if (valueSketch == null) {
                    valueSketch = new TDigestState(MedianAbsoluteDeviationAggregator.this.compression);
                    MedianAbsoluteDeviationAggregator.this.valueSketches.set(bucket, (Object)valueSketch);
                }
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    for (int i = 0; i < valueCount; ++i) {
                        double value = values.nextValue();
                        valueSketch.add(value);
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        if (this.hasDataForBucket(bucket)) {
            TDigestState valueSketch = (TDigestState)((Object)this.valueSketches.get(bucket));
            return new InternalMedianAbsoluteDeviation(this.name, this.metadata(), this.format, valueSketch);
        }
        return this.buildEmptyAggregation();
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMedianAbsoluteDeviation(this.name, this.metadata(), this.format, new TDigestState(this.compression));
    }

    @Override
    public void doClose() {
        Releasables.close(this.valueSketches);
    }
}

