/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.util.Comparators;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import java.util.Map;
import org.opensearch.search.aggregations.metrics.MetricsAggregator;

public abstract class NumericMetricsAggregator
extends MetricsAggregator {
    private NumericMetricsAggregator(String name, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
    }

    public boolean isCompatibleForTopmost() {
        return true;
    }

    public static abstract class MultiValue
    extends NumericMetricsAggregator {
        protected MultiValue(String name, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, metadata);
        }

        public abstract boolean hasMetric(String var1);

        public abstract double metric(String var1, long var2);

        public BucketOrder.BucketComparator bucketComparator(String key, SortOrder order) {
            if (key == null) {
                throw new IllegalArgumentException("When ordering on a multi-value metrics aggregation a metric name must be specified.");
            }
            if (!this.hasMetric(key)) {
                throw new IllegalArgumentException("Unknown metric name [" + key + "] on multi-value metrics aggregation [" + this.name() + "]");
            }
            return (lhs, rhs) -> Comparators.compareDiscardNaN((double)this.metric(key, lhs), (double)this.metric(key, rhs), (order == SortOrder.ASC ? 1 : 0) != 0);
        }
    }

    public static abstract class SingleValue
    extends NumericMetricsAggregator {
        protected SingleValue(String name, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, metadata);
        }

        public abstract double metric(long var1);

        public BucketOrder.BucketComparator bucketComparator(String key, SortOrder order) {
            if (key != null && !"value".equals(key)) {
                throw new IllegalArgumentException("Ordering on a single-value metrics aggregation can only be done on its value. Either drop the key (a la \"" + this.name() + "\") or change it to \"value\" (a la \"" + this.name() + ".value\")");
            }
            return (lhs, rhs) -> Comparators.compareDiscardNaN((double)this.metric(lhs), (double)this.metric(rhs), (order == SortOrder.ASC ? 1 : 0) != 0);
        }
    }
}

