/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import org.opensearch.search.aggregations.ParsedAggregation;
import org.opensearch.search.aggregations.metrics.Cardinality;

public class ParsedCardinality
extends ParsedAggregation
implements Cardinality {
    private long cardinalityValue;
    private static final ObjectParser<ParsedCardinality, Void> PARSER = new ObjectParser(ParsedCardinality.class.getSimpleName(), true, ParsedCardinality::new);

    @Override
    public String getValueAsString() {
        return Double.toString(this.cardinalityValue);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.cardinalityValue;
    }

    public String getType() {
        return "cardinality";
    }

    public static ParsedCardinality fromXContent(XContentParser parser, String name) {
        ParsedCardinality cardinality = (ParsedCardinality)PARSER.apply(parser, null);
        cardinality.setName(name);
        return cardinality;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.cardinalityValue);
        return builder;
    }

    static {
        ParsedCardinality.declareAggregationFields(PARSER);
        PARSER.declareLong((agg, value) -> {
            agg.cardinalityValue = value;
        }, Aggregation.CommonFields.VALUE);
    }
}

