/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.opensearch.search.aggregations.metrics.PercentileRanksAggregationBuilder;
import org.opensearch.search.aggregations.metrics.PercentilesAggregatorSupplier;
import org.opensearch.search.aggregations.metrics.PercentilesConfig;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

class PercentileRanksAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double[] percents;
    private final PercentilesConfig percentilesConfig;
    private final boolean keyed;

    static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(PercentileRanksAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (name, valuesSource, context, parent, percents, percentilesConfig, keyed, formatter, metadata) -> percentilesConfig.createPercentileRanksAggregator(name, valuesSource, context, parent, percents, keyed, formatter, metadata), true);
    }

    PercentileRanksAggregatorFactory(String name, ValuesSourceConfig config, double[] percents, PercentilesConfig percentilesConfig, boolean keyed, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.percents = percents;
        this.percentilesConfig = percentilesConfig;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return this.percentilesConfig.createPercentileRanksAggregator(this.name, null, searchContext, parent, this.percents, this.keyed, this.config.format(), metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata) throws IOException {
        return ((PercentilesAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(PercentileRanksAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.config.getValuesSource(), searchContext, parent, this.percents, this.percentilesConfig, this.keyed, this.config.format(), metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

