/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AbstractAggregationBuilder;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.opensearch.script.ScriptedMetricAggContexts;
import org.opensearch.search.aggregations.metrics.InternalScriptedMetric;
import org.opensearch.search.aggregations.metrics.ScriptedMetricAggregatorFactory;

public class ScriptedMetricAggregationBuilder
extends AbstractAggregationBuilder<ScriptedMetricAggregationBuilder> {
    public static final String NAME = "scripted_metric";
    private static final ParseField INIT_SCRIPT_FIELD = new ParseField("init_script", new String[0]);
    private static final ParseField MAP_SCRIPT_FIELD = new ParseField("map_script", new String[0]);
    private static final ParseField COMBINE_SCRIPT_FIELD = new ParseField("combine_script", new String[0]);
    private static final ParseField REDUCE_SCRIPT_FIELD = new ParseField("reduce_script", new String[0]);
    private static final ParseField PARAMS_FIELD = new ParseField("params", new String[0]);
    public static final ConstructingObjectParser<ScriptedMetricAggregationBuilder, String> PARSER = new ConstructingObjectParser("scripted_metric", false, (args, name) -> {
        ScriptedMetricAggregationBuilder builder = new ScriptedMetricAggregationBuilder((String)name);
        builder.mapScript((Script)args[0]);
        return builder;
    });
    private Script initScript;
    private Script mapScript;
    private Script combineScript;
    private Script reduceScript;
    private Map<String, Object> params;

    public ScriptedMetricAggregationBuilder(String name) {
        super(name);
    }

    protected ScriptedMetricAggregationBuilder(ScriptedMetricAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.initScript = clone.initScript;
        this.mapScript = clone.mapScript;
        this.combineScript = clone.combineScript;
        this.reduceScript = clone.reduceScript;
        this.params = clone.params;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new ScriptedMetricAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public ScriptedMetricAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.initScript = (Script)in.readOptionalWriteable(Script::new);
        this.mapScript = (Script)in.readOptionalWriteable(Script::new);
        this.combineScript = (Script)in.readOptionalWriteable(Script::new);
        this.reduceScript = (Script)in.readOptionalWriteable(Script::new);
        if (in.readBoolean()) {
            this.params = in.readMap();
        }
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.initScript);
        out.writeOptionalWriteable((Writeable)this.mapScript);
        out.writeOptionalWriteable((Writeable)this.combineScript);
        out.writeOptionalWriteable((Writeable)this.reduceScript);
        boolean hasParams = this.params != null;
        out.writeBoolean(hasParams);
        if (hasParams) {
            out.writeMap(this.params);
        }
    }

    public ScriptedMetricAggregationBuilder initScript(Script initScript) {
        if (initScript == null) {
            throw new IllegalArgumentException("[initScript] must not be null: [" + this.name + "]");
        }
        this.initScript = initScript;
        return this;
    }

    public Script initScript() {
        return this.initScript;
    }

    public ScriptedMetricAggregationBuilder mapScript(Script mapScript) {
        if (mapScript == null) {
            throw new IllegalArgumentException("[mapScript] must not be null: [" + this.name + "]");
        }
        this.mapScript = mapScript;
        return this;
    }

    public Script mapScript() {
        return this.mapScript;
    }

    public ScriptedMetricAggregationBuilder combineScript(Script combineScript) {
        if (combineScript == null) {
            throw new IllegalArgumentException("[combineScript] must not be null: [" + this.name + "]");
        }
        this.combineScript = combineScript;
        return this;
    }

    public Script combineScript() {
        return this.combineScript;
    }

    public ScriptedMetricAggregationBuilder reduceScript(Script reduceScript) {
        if (reduceScript == null) {
            throw new IllegalArgumentException("[reduceScript] must not be null: [" + this.name + "]");
        }
        this.reduceScript = reduceScript;
        return this;
    }

    public Script reduceScript() {
        return this.reduceScript;
    }

    public ScriptedMetricAggregationBuilder params(Map<String, Object> params) {
        if (params == null) {
            throw new IllegalArgumentException("[params] must not be null: [" + this.name + "]");
        }
        this.params = params;
        return this;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    protected ScriptedMetricAggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        Map initScriptParams;
        ScriptedMetricAggContexts.InitScript.Factory compiledInitScript;
        if (this.combineScript == null) {
            throw new IllegalArgumentException("[combineScript] must not be null: [" + this.name + "]");
        }
        if (this.reduceScript == null) {
            throw new IllegalArgumentException("[reduceScript] must not be null: [" + this.name + "]");
        }
        if (this.initScript != null) {
            compiledInitScript = (ScriptedMetricAggContexts.InitScript.Factory)context.compile(this.initScript, ScriptedMetricAggContexts.InitScript.CONTEXT);
            initScriptParams = this.initScript.getParams();
        } else {
            compiledInitScript = null;
            initScriptParams = Collections.emptyMap();
        }
        ScriptedMetricAggContexts.MapScript.Factory compiledMapScript = (ScriptedMetricAggContexts.MapScript.Factory)context.compile(this.mapScript, ScriptedMetricAggContexts.MapScript.CONTEXT);
        Map mapScriptParams = this.mapScript.getParams();
        ScriptedMetricAggContexts.CombineScript.Factory compiledCombineScript = (ScriptedMetricAggContexts.CombineScript.Factory)context.compile(this.combineScript, ScriptedMetricAggContexts.CombineScript.CONTEXT);
        Map combineScriptParams = this.combineScript.getParams();
        return new ScriptedMetricAggregatorFactory(this.name, compiledMapScript, mapScriptParams, compiledInitScript, initScriptParams, compiledCombineScript, combineScriptParams, this.reduceScript, this.params, context, parent, subfactoriesBuilder, this.metadata);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        if (this.initScript != null) {
            builder.field(INIT_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.initScript);
        }
        if (this.mapScript != null) {
            builder.field(MAP_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.mapScript);
        }
        if (this.combineScript != null) {
            builder.field(COMBINE_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.combineScript);
        }
        if (this.reduceScript != null) {
            builder.field(REDUCE_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.reduceScript);
        }
        if (this.params != null) {
            builder.field(PARAMS_FIELD.getPreferredName());
            builder.map(this.params);
        }
        builder.endObject();
        return builder;
    }

    public String getType() {
        return NAME;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.initScript, this.mapScript, this.combineScript, this.reduceScript, this.params);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ScriptedMetricAggregationBuilder other = (ScriptedMetricAggregationBuilder)((Object)obj);
        return Objects.equals(this.initScript, other.initScript) && Objects.equals(this.mapScript, other.mapScript) && Objects.equals(this.combineScript, other.combineScript) && Objects.equals(this.reduceScript, other.reduceScript) && Objects.equals(this.params, other.params);
    }

    static {
        Script.declareScript(PARSER, ScriptedMetricAggregationBuilder::initScript, (ParseField)INIT_SCRIPT_FIELD);
        Script.declareScript(PARSER, (BiConsumer)ConstructingObjectParser.constructorArg(), (ParseField)MAP_SCRIPT_FIELD);
        Script.declareScript(PARSER, ScriptedMetricAggregationBuilder::combineScript, (ParseField)COMBINE_SCRIPT_FIELD);
        Script.declareScript(PARSER, ScriptedMetricAggregationBuilder::reduceScript, (ParseField)REDUCE_SCRIPT_FIELD);
        PARSER.declareObject(ScriptedMetricAggregationBuilder::params, (p, name) -> p.map(), PARAMS_FIELD);
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.METRIC;
        }

        public String getName() {
            return ScriptedMetricAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return ScriptedMetricAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalScriptedMetric::new));
        }

        public ConstructingObjectParser getParser() {
            return PARSER;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return null;
        }
    }
}

