/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.LongArray;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.geo.MultiGeoPointValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;

public class ValueCountAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource valuesSource;
    LongArray counts;

    public ValueCountAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchExecutionContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, aggregationContext, parent, metadata);
        ValuesSource valuesSource = this.valuesSource = valuesSourceConfig.hasValues() ? valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.counts = this.context.bigArrays().newLongArray(1L, true);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        if (this.valuesSource instanceof NumericValuesSource) {
            final SortedNumericDocValues values = ((NumericValuesSource)this.valuesSource).longValues(ctx);
            return new LeafBucketCollectorBase(sub, values){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                    if (values.advanceExact(doc)) {
                        ValueCountAggregator.this.counts.increment(bucket, (long)values.docValueCount());
                    }
                }
            };
        }
        if (this.valuesSource instanceof GeoPointValuesSource) {
            final MultiGeoPointValues values = ((GeoPointValuesSource)this.valuesSource).geoPointValues(ctx);
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                    if (values.advanceExact(doc)) {
                        ValueCountAggregator.this.counts.increment(bucket, (long)values.docValueCount());
                    }
                }
            };
        }
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    ValueCountAggregator.this.counts.increment(bucket, (long)values.docValueCount());
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null || owningBucketOrd >= this.counts.size() ? 0.0 : (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalValueCount(this.name, this.counts.get(bucket), this.metadata());
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalValueCount(this.name, 0L, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.counts);
    }
}

