/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.search.aggregations.metrics.MetricAggregatorSupplier;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregator;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

class ValueCountAggregatorFactory
extends ValuesSourceAggregatorFactory {
    public static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(ValueCountAggregationBuilder.REGISTRY_KEY, Stream.of(CoreValuesSourceType.ALL_CORE, GeoValuesSourceType.ALL).flatMap(x -> x.stream()).collect(Collectors.toUnmodifiableList()), ValueCountAggregator::new, true);
    }

    ValueCountAggregatorFactory(String name, ValuesSourceConfig config, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new ValueCountAggregator(this.name, this.config, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata) throws IOException {
        return ((MetricAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(ValueCountAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.config, searchContext, parent, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

