/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.opensearch.search.aggregations.metrics.WeightedAvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.WeightedAvgAggregator;
import org.opensearch.search.aggregations.support.MultiValuesSource;
import org.opensearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;

class WeightedAvgAggregatorFactory
extends MultiValuesSourceAggregatorFactory {
    WeightedAvgAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, DocValueFormat format, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, configs, format, context, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new WeightedAvgAggregator(this.name, null, this.format, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Map<String, ValuesSourceConfig> configs, DocValueFormat format, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        MultiValuesSource.NumericMultiValuesSource numericMultiVS = new MultiValuesSource.NumericMultiValuesSource(configs);
        if (numericMultiVS.areValuesSourcesEmpty()) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        return new WeightedAvgAggregator(this.name, numericMultiVS, format, searchContext, parent, metadata);
    }

    public String getStatsSubtype() {
        return ((ValuesSourceConfig)this.configs.get(WeightedAvgAggregationBuilder.VALUE_FIELD.getPreferredName())).valueSourceType().typeName();
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

