/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.PipelineAggregationBuilder;
import io.skylite.core.aggregations.pipeline.PipelineAggregator;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Rounding;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.DerivativePipelineAggregator;
import org.opensearch.search.aggregations.pipeline.InternalDerivative;

public class DerivativePipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<DerivativePipelineAggregationBuilder> {
    public static final String NAME = "derivative";
    private static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    private static final ParseField GAP_POLICY_FIELD = new ParseField("gap_policy", new String[0]);
    private static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    private String format;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
    private String units;

    public DerivativePipelineAggregationBuilder(String name, String bucketsPath) {
        this(name, new String[]{bucketsPath});
    }

    private DerivativePipelineAggregationBuilder(String name, String[] bucketsPaths) {
        super(name, NAME, bucketsPaths);
    }

    public DerivativePipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
        if (in.readBoolean()) {
            this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        }
        this.units = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
        boolean hasGapPolicy = this.gapPolicy != null;
        out.writeBoolean(hasGapPolicy);
        if (hasGapPolicy) {
            this.gapPolicy.writeTo(out);
        }
        out.writeOptionalString(this.units);
    }

    public DerivativePipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    public DerivativePipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[gapPolicy] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    public DerivativePipelineAggregationBuilder unit(String units) {
        if (units == null) {
            throw new IllegalArgumentException("[units] must not be null: [" + this.name + "]");
        }
        this.units = units;
        return this;
    }

    public DerivativePipelineAggregationBuilder unit(DateHistogramInterval units) {
        if (units == null) {
            throw new IllegalArgumentException("[units] must not be null: [" + this.name + "]");
        }
        this.units = units.toString();
        return this;
    }

    public String unit() {
        return this.units;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        Object formatter = this.format != null ? new DocValueFormat.Decimal(this.format) : DocValueFormat.RAW;
        Long xAxisUnits = null;
        if (this.units != null) {
            Rounding.DateTimeUnit dateTimeUnit = DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(this.units);
            if (dateTimeUnit != null) {
                xAxisUnits = dateTimeUnit.getField().getBaseUnit().getDuration().toMillis();
            } else {
                TimeValue timeValue = TimeValue.parseTimeValue((String)this.units, null, (String)(((Object)((Object)this)).getClass().getSimpleName() + ".unit"));
                if (timeValue != null) {
                    xAxisUnits = timeValue.getMillis();
                }
            }
        }
        return new DerivativePipelineAggregator(this.name, this.bucketsPaths, (DocValueFormat)formatter, this.gapPolicy, xAxisUnits, metadata);
    }

    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        if (this.bucketsPaths.length != 1) {
            context.addValidationError(PipelineAggregationBuilder.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
        }
        context.validateParentAggSequentiallyOrdered(NAME, this.name);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(FORMAT_FIELD.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(GAP_POLICY_FIELD.getPreferredName(), this.gapPolicy.getName());
        }
        if (this.units != null) {
            builder.field(UNIT_FIELD.getPreferredName(), this.units);
        }
        return builder;
    }

    public static DerivativePipelineAggregationBuilder parse(XContentParser parser, String pipelineAggregatorName) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        String units = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (FORMAT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (BUCKETS_PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                if (GAP_POLICY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(parser.text(), parser.getTokenLocation());
                    continue;
                }
                if (UNIT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    units = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (BUCKETS_PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[0]);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " in [" + pipelineAggregatorName + "].", new Object[0]);
        }
        if (bucketsPaths == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + BUCKETS_PATH_FIELD.getPreferredName() + "] for derivative aggregation [" + pipelineAggregatorName + "]", new Object[0]);
        }
        DerivativePipelineAggregationBuilder factory = new DerivativePipelineAggregationBuilder(pipelineAggregatorName, (String)bucketsPaths[0]);
        if (format != null) {
            factory.format(format);
        }
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        if (units != null) {
            factory.unit(units);
        }
        return factory;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DerivativePipelineAggregationBuilder other = (DerivativePipelineAggregationBuilder)((Object)obj);
        return Objects.equals(this.format, other.format) && this.gapPolicy == other.gapPolicy && Objects.equals(this.units, other.units);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.format, this.gapPolicy, this.units});
    }

    public String getWriteableName() {
        return NAME;
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.PIPELINE;
        }

        public String getName() {
            return DerivativePipelineAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return DerivativePipelineAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalDerivative::new));
        }

        public ContextParser<String, DerivativePipelineAggregationBuilder> getParser() {
            return DerivativePipelineAggregationBuilder::parse;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return null;
        }
    }
}

