/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.index.fielddata.DocValueFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.opensearch.search.aggregations.pipeline.InternalBucketMetricValue;

public class MinBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private List<String> minBucketKeys;
    private double minValue;

    MinBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, formatter, metadata);
    }

    @Override
    protected void preCollection() {
        this.minBucketKeys = new ArrayList<String>();
        this.minValue = Double.POSITIVE_INFINITY;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        if (bucketValue < this.minValue) {
            this.minBucketKeys.clear();
            this.minBucketKeys.add(bucketKey);
            this.minValue = bucketValue;
        } else if (bucketValue.equals(this.minValue)) {
            this.minBucketKeys.add(bucketKey);
        }
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        String[] keys = this.minBucketKeys.toArray(new String[0]);
        return new InternalBucketMetricValue(this.name(), keys, this.minValue, this.format, this.metadata());
    }
}

