/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.aggregations.bucket.MultiBucketsAggregation;
import io.skylite.core.aggregations.pipeline.PipelineAggregator;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.script.Script;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.InternalSimpleValue;
import org.opensearch.search.aggregations.pipeline.MovingFunctionScript;

public class MovFnPipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;
    private final BucketHelpers.GapPolicy gapPolicy;
    private final Script script;
    private final String bucketsPath;
    private final int window;
    private final int shift;

    MovFnPipelineAggregator(String name, String bucketsPath, Script script, int window, int shift, DocValueFormat formatter, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, new String[]{bucketsPath}, metadata);
        this.bucketsPath = bucketsPath;
        this.script = script;
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.window = window;
        this.shift = shift;
    }

    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)((Object)histo);
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>();
        MovingFunctionScript.Factory scriptFactory = (MovingFunctionScript.Factory)reduceContext.scriptService().compile(this.script, MovingFunctionScript.CONTEXT);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (this.script.getParams() != null) {
            vars.putAll(this.script.getParams());
        }
        MovingFunctionScript executableScript = scriptFactory.newInstance();
        List<Double> values = buckets.stream().map(b -> BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, b, this.bucketsPaths()[0], this.gapPolicy)).filter(v -> v != null && !v.isNaN()).collect(Collectors.toList());
        int index = 0;
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, bucket, this.bucketsPaths()[0], this.gapPolicy);
            InternalMultiBucketAggregation.InternalBucket newBucket = bucket;
            if (thisBucketValue != null && !thisBucketValue.isNaN()) {
                int fromIndex = this.clamp(index - this.window + this.shift, values);
                int toIndex = this.clamp(index + this.shift, values);
                double movavg = executableScript.execute(vars, values.subList(fromIndex, toIndex).stream().mapToDouble(Double::doubleValue).toArray());
                List aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(InternalAggregation.class::cast).collect(Collectors.toList());
                aggs.add(new InternalSimpleValue(this.name(), movavg, this.formatter, this.metadata()));
                newBucket = factory.createBucket(factory.getKey(bucket), bucket.getDocCount(), InternalAggregations.from(aggs));
                ++index;
            }
            newBuckets.add(newBucket);
        }
        return factory.createAggregation(newBuckets);
    }

    private int clamp(int index, List<Double> list) {
        if (index < 0) {
            return 0;
        }
        if (index > list.size()) {
            return list.size();
        }
        return index;
    }
}

