/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.index.fielddata.DocValueFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.opensearch.search.aggregations.pipeline.InternalPercentilesBucket;

public class PercentilesBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private final double[] percents;
    private boolean keyed = true;
    private List<Double> data;

    PercentilesBucketPipelineAggregator(String name, double[] percents, boolean keyed, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, formatter, metadata);
        this.percents = percents;
        this.keyed = keyed;
    }

    @Override
    protected void preCollection() {
        this.data = new ArrayList<Double>(1024);
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.data.add(bucketValue);
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        Collections.sort(this.data);
        double[] percentiles = new double[this.percents.length];
        if (this.data.size() == 0) {
            for (int i = 0; i < this.percents.length; ++i) {
                percentiles[i] = Double.NaN;
            }
        } else {
            for (int i = 0; i < this.percents.length; ++i) {
                int index = (int)Math.round(this.percents[i] / 100.0 * (double)(this.data.size() - 1));
                percentiles[i] = this.data.get(index);
            }
        }
        return new InternalPercentilesBucket(this.name(), this.percents, percentiles, this.keyed, this.format, metadata);
    }
}

