/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.PipelineAggregationBuilder;
import io.skylite.core.aggregations.pipeline.PipelineAggregator;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.SerialDiffPipelineAggregator;

public class SerialDiffPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<SerialDiffPipelineAggregationBuilder> {
    public static final String NAME = "serial_diff";
    private static final ParseField GAP_POLICY = new ParseField("gap_policy", new String[0]);
    private static final ParseField LAG = new ParseField("lag", new String[0]);
    private String format;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
    private int lag = 1;

    public SerialDiffPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    public SerialDiffPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.lag = in.readVInt();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
        out.writeVInt(this.lag);
    }

    public SerialDiffPipelineAggregationBuilder lag(int lag) {
        if (lag <= 0) {
            throw new IllegalArgumentException("[lag] must be a positive integer: [" + this.name + "]");
        }
        this.lag = lag;
        return this;
    }

    public int lag() {
        return this.lag;
    }

    public SerialDiffPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    public SerialDiffPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[gapPolicy] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new SerialDiffPipelineAggregator(this.name, this.bucketsPaths, this.formatter(), this.gapPolicy, this.lag, metadata);
    }

    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        context.validateParentAggSequentiallyOrdered(NAME, this.name);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(PipelineAggregationBuilder.Parser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        builder.field(LAG.getPreferredName(), this.lag);
        return builder;
    }

    public static SerialDiffPipelineAggregationBuilder parse(String reducerName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        Integer lag = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (PipelineAggregationBuilder.Parser.FORMAT.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (PipelineAggregationBuilder.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                if (GAP_POLICY.match(currentFieldName, parser.getDeprecationHandler())) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(parser.text(), parser.getTokenLocation());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (LAG.match(currentFieldName, parser.getDeprecationHandler())) {
                    lag = parser.intValue(true);
                    if (lag > 0) continue;
                    throw new ParsingException(parser.getTokenLocation(), "Lag must be a positive, non-zero integer.  Value supplied was" + lag + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (PipelineAggregationBuilder.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[0]);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " in [" + reducerName + "].", new Object[]{parser.getTokenLocation()});
        }
        if (bucketsPaths == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + PipelineAggregationBuilder.Parser.BUCKETS_PATH.getPreferredName() + "] for derivative aggregation [" + reducerName + "]", new Object[0]);
        }
        SerialDiffPipelineAggregationBuilder factory = new SerialDiffPipelineAggregationBuilder(reducerName, (String)bucketsPaths[0]);
        if (lag != null) {
            factory.lag(lag);
        }
        if (format != null) {
            factory.format(format);
        }
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        return factory;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.format, this.gapPolicy, this.lag});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SerialDiffPipelineAggregationBuilder other = (SerialDiffPipelineAggregationBuilder)((Object)obj);
        return Objects.equals(this.format, other.format) && Objects.equals((Object)this.gapPolicy, (Object)other.gapPolicy) && Objects.equals(this.lag, other.lag);
    }

    public String getWriteableName() {
        return NAME;
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.PIPELINE;
        }

        public String getName() {
            return SerialDiffPipelineAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return SerialDiffPipelineAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.emptyList();
        }

        public ContextParser<String, SerialDiffPipelineAggregationBuilder> getParser() {
            return (p, s) -> SerialDiffPipelineAggregationBuilder.parse(s, p);
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return null;
        }
    }
}

