/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.index.fielddata.DocValueFormat;
import java.util.Map;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.opensearch.search.aggregations.pipeline.InternalSimpleValue;

public class SumBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private double sum = 0.0;

    SumBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, formatter, metadata);
    }

    @Override
    protected void preCollection() {
        this.sum = 0.0;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.sum += bucketValue.doubleValue();
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        return new InternalSimpleValue(this.name(), this.sum, this.format, metadata);
    }
}

