/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import io.skylite.common.collect.Tuple;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValueTypeProvider;
import io.skylite.core.common.io.stream.StreamInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public class ValueTypeRegistry {
    private static List<ValueType> REGISTERED_VALUE_TYPES;
    private static List<Tuple<List<String>, ValueType>> REGISTERED_LENIENT_MAPPINGS;

    private static void register(ValueType[] valueTypes, Tuple<List<String>, ValueType>[] lenientTypes) {
        ArrayList<ValueType> tempRegistry = new ArrayList<ValueType>(valueTypes.length);
        ArrayList<ValueType> tempLenientTypes = new ArrayList<ValueType>(lenientTypes.length);
        for (ValueType valueType : valueTypes) {
            if (tempRegistry.stream().anyMatch(v -> v.getId() == valueType.getId() || v.getPreferredName().equals(valueType.getPreferredName()))) {
                throw new IllegalArgumentException("unable to register valueType: [" + valueType.getPreferredName() + "]. Type already exists or id [" + valueType.getId() + "] is not unique.");
            }
            tempRegistry.add(valueType);
        }
        for (ValueType valueType : lenientTypes) {
            if (tempLenientTypes.stream().anyMatch(arg_0 -> ValueTypeRegistry.lambda$register$1((Tuple)valueType, arg_0))) {
                throw new IllegalArgumentException("unable to register lenient names for type: [" + ((ValueType)valueType.v2()).getPreferredName() + "]. Lenient mapping already exists.");
            }
            tempLenientTypes.add(valueType);
        }
        REGISTERED_VALUE_TYPES = List.copyOf(tempRegistry);
        REGISTERED_LENIENT_MAPPINGS = List.copyOf(tempLenientTypes);
    }

    public static ValueType lenientParse(String type) {
        Optional<Tuple> foundType = REGISTERED_LENIENT_MAPPINGS.stream().filter(v -> ((List)v.v1()).stream().anyMatch(t -> t.equals(type))).distinct().findFirst();
        if (foundType.isPresent()) {
            return (ValueType)foundType.get().v2();
        }
        return null;
    }

    public static ValueType readFromStream(StreamInput in) throws IOException {
        byte id = in.readByte();
        Optional<ValueType> foundType = REGISTERED_VALUE_TYPES.stream().filter(v -> v.getId() == id).findAny();
        if (!foundType.isPresent()) {
            throw new IOException("No ValueType found for id [" + id + "], there are " + REGISTERED_VALUE_TYPES.size() + " registered ValueType");
        }
        return foundType.get();
    }

    private static /* synthetic */ boolean lambda$register$1(Tuple lenientType, Tuple t) {
        return ((List)t.v1()).stream().filter(((List)lenientType.v1())::contains).findAny().isPresent();
    }

    static {
        ArrayList valueTypes = new ArrayList();
        ArrayList lenientTypes = new ArrayList();
        for (ValueTypeProvider provider : ServiceLoader.load(ValueTypeProvider.class, ValueTypeProvider.class.getClassLoader())) {
            valueTypes.addAll(provider.getValueTypes());
            lenientTypes.addAll(provider.getLenientTypes());
        }
        ValueTypeRegistry.register(valueTypes.toArray(new ValueType[0]), lenientTypes.toArray(new Tuple[0]));
    }
}

