/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import io.skylite.Version;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AbstractAggregationBuilder;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationInitializationException;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValueTypes;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.AbstractObjectParser;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.support.ValueTypeRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public abstract class ValuesSourceAggregationBuilder<AB extends ValuesSourceAggregationBuilder<AB>>
extends AbstractAggregationBuilder<AB> {
    private String field = null;
    private Script script = null;
    private ValueType userValueTypeHint = null;
    private String format = null;
    private Object missing = null;
    private ZoneId timeZone = null;
    protected ValuesSourceConfig config;

    public static <T> void declareFields(AbstractObjectParser<? extends ValuesSourceAggregationBuilder<?>, T> objectParser, boolean scriptable, boolean formattable, boolean timezoneAware) {
        ValuesSourceAggregationBuilder.declareFields(objectParser, scriptable, formattable, timezoneAware, true);
    }

    public static <T> void declareFields(AbstractObjectParser<? extends ValuesSourceAggregationBuilder<?>, T> objectParser, boolean scriptable, boolean formattable, boolean timezoneAware, boolean fieldRequired) {
        objectParser.declareField(ValuesSourceAggregationBuilder::field, XContentParser::text, ParseField.CommonFields.FIELD, ObjectParser.ValueType.STRING);
        objectParser.declareField(ValuesSourceAggregationBuilder::missing, XContentParser::objectText, ParseField.CommonFields.MISSING, ObjectParser.ValueType.VALUE);
        objectParser.declareField(ValuesSourceAggregationBuilder::userValueTypeHint, p -> {
            ValueType type = ValueTypeRegistry.lenientParse(p.text());
            if (type == null) {
                throw new IllegalArgumentException("Unknown value type [" + p.text() + "]");
            }
            return type;
        }, ValueTypes.VALUE_TYPE, ObjectParser.ValueType.STRING);
        if (formattable) {
            objectParser.declareField(ValuesSourceAggregationBuilder::format, XContentParser::text, ParseField.CommonFields.FORMAT, ObjectParser.ValueType.STRING);
        }
        if (scriptable) {
            objectParser.declareField(ValuesSourceAggregationBuilder::script, (parser, context) -> Script.parse((XContentParser)parser), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
            if (fieldRequired) {
                String[] fields = new String[]{ParseField.CommonFields.FIELD.getPreferredName(), Script.SCRIPT_PARSE_FIELD.getPreferredName()};
                objectParser.declareRequiredFieldSet(fields);
            }
        } else if (fieldRequired) {
            objectParser.declareRequiredFieldSet(new String[]{ParseField.CommonFields.FIELD.getPreferredName()});
        }
        if (timezoneAware) {
            objectParser.declareField(ValuesSourceAggregationBuilder::timeZone, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return ZoneId.of(p.text());
                }
                return ZoneOffset.ofHours(p.intValue());
            }, ParseField.CommonFields.TIME_ZONE, ObjectParser.ValueType.LONG);
        }
    }

    protected ValuesSourceAggregationBuilder(String name) {
        super(name);
    }

    protected ValuesSourceAggregationBuilder(ValuesSourceAggregationBuilder<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.field = clone.field;
        this.userValueTypeHint = clone.userValueTypeHint;
        this.format = clone.format;
        this.missing = clone.missing;
        this.timeZone = clone.timeZone;
        this.config = clone.config;
        this.script = clone.script;
    }

    protected ValuesSourceAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        if (this.serializeTargetValueType(in.getVersion())) {
            ValueType valueType = (ValueType)in.readOptionalWriteable(ValueTypeRegistry::readFromStream);
            assert (valueType == null);
        }
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.field = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        if (in.readBoolean()) {
            this.userValueTypeHint = ValueTypeRegistry.readFromStream(in);
        }
        this.format = in.readOptionalString();
        this.missing = in.readGenericValue();
        this.timeZone = in.readOptionalZoneId();
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        if (this.serializeTargetValueType(out.getVersion())) {
            out.writeOptionalWriteable(null);
        }
        out.writeOptionalString(this.field);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        boolean hasValueType = this.userValueTypeHint != null;
        out.writeBoolean(hasValueType);
        if (hasValueType) {
            this.userValueTypeHint.writeTo(out);
        }
        out.writeOptionalString(this.format);
        out.writeGenericValue(this.missing);
        out.writeOptionalZoneId(this.timeZone);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected boolean serializeTargetValueType(Version version) {
        return false;
    }

    public AB field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("[field] must not be null: [" + this.name + "]");
        }
        this.field = field;
        return (AB)((Object)this);
    }

    public String field() {
        return this.field;
    }

    public AB script(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("[script] must not be null: [" + this.name + "]");
        }
        this.script = script;
        return (AB)((Object)this);
    }

    public Script script() {
        return this.script;
    }

    public AB userValueTypeHint(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[userValueTypeHint] must not be null: [" + this.name + "]");
        }
        this.userValueTypeHint = valueType;
        return (AB)((Object)this);
    }

    public ValueType userValueTypeHint() {
        return this.userValueTypeHint;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)((Object)this);
    }

    public String format() {
        return this.format;
    }

    public AB missing(Object missing) {
        if (missing == null) {
            throw new IllegalArgumentException("[missing] must not be null: [" + this.name + "]");
        }
        this.missing = missing;
        return (AB)((Object)this);
    }

    public Object missing() {
        return this.missing;
    }

    public AB timeZone(ZoneId timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("[timeZone] must not be null: [" + this.name + "]");
        }
        this.timeZone = timeZone;
        return (AB)((Object)this);
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    protected final ValuesSourceAggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ValuesSourceConfig config = this.resolveConfig(context);
        if (context.getAggregationRegistry().isRegistered(this.getRegistryKey())) {
            context.getAggregationRegistry().getAggregator(this.getRegistryKey(), config);
        }
        ValuesSourceAggregatorFactory factory = this.innerBuild(context, config, parent, subFactoriesBuilder);
        return factory;
    }

    protected abstract AggregationRegistry.RegistryKey<?> getRegistryKey();

    protected abstract ValuesSourceType defaultValueSourceType();

    protected ValuesSourceConfig resolveConfig(AggregationContext context) {
        return ValuesSourceConfig.resolve((AggregationContext)context, (ValueType)this.userValueTypeHint, (String)this.field, (Script)this.script, (Object)this.missing, (ZoneId)this.timeZone, (String)this.format, (ValuesSourceType)this.defaultValueSourceType());
    }

    protected abstract ValuesSourceAggregatorFactory innerBuild(AggregationContext var1, ValuesSourceConfig var2, AggregatorFactory var3, AggregatorFactories.Builder var4) throws IOException;

    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", (ToXContent)this.script);
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.toString());
        }
        if (this.userValueTypeHint != null) {
            builder.field("value_type", this.userValueTypeHint.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field, this.format, this.missing, this.script, this.timeZone, this.userValueTypeHint);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ValuesSourceAggregationBuilder other = (ValuesSourceAggregationBuilder)((Object)obj);
        return Objects.equals(this.field, other.field) && Objects.equals(this.format, other.format) && Objects.equals(this.missing, other.missing) && Objects.equals(this.script, other.script) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.userValueTypeHint, other.userValueTypeHint);
    }

    public static abstract class LeafOnly<VS extends ValuesSource, AB extends ValuesSourceAggregationBuilder<AB>>
    extends ValuesSourceAggregationBuilder<AB> {
        protected LeafOnly(String name) {
            super(name);
        }

        protected LeafOnly(LeafOnly<VS, AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            super(clone, factoriesBuilder, metadata);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in) throws IOException {
            super(in);
        }

        public final AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }

        public final AggregationBuilder.BucketCardinality bucketCardinality() {
            return AggregationBuilder.BucketCardinality.NONE;
        }
    }
}

