/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.action.search.SearchTask;
import io.skylite.core.monitor.jvm.JvmStats;
import io.skylite.core.monitor.process.ProcessProbe;
import io.skylite.core.search.backpressure.SearchBackpressureMode;
import io.skylite.core.search.backpressure.stats.SearchBackpressureStats;
import io.skylite.core.search.backpressure.stats.SearchShardTaskStats;
import io.skylite.core.search.backpressure.stats.SearchTaskStats;
import io.skylite.core.search.backpressure.trackers.CpuUsageTracker;
import io.skylite.core.search.backpressure.trackers.ElapsedTimeTracker;
import io.skylite.core.search.backpressure.trackers.HeapUsageTracker;
import io.skylite.core.search.backpressure.trackers.NodeDuressTracker;
import io.skylite.core.search.backpressure.trackers.TaskResourceUsageTracker;
import io.skylite.core.search.backpressure.trackers.TaskResourceUsageTrackerType;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.tasks.CancellableTask;
import io.skylite.core.tasks.SearchBackpressureTask;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskCancellation;
import io.skylite.core.tasks.TaskManager;
import io.skylite.core.tasks.TaskResourceTrackingService;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.backpressure.SearchBackpressureState;
import org.opensearch.search.backpressure.settings.SearchBackpressureSettings;
import org.opensearch.search.backpressure.settings.SearchShardTaskSettings;
import org.opensearch.search.backpressure.settings.SearchTaskSettings;

public class SearchBackpressureService
extends AbstractLifecycleComponent
implements TaskResourceTrackingService.TaskCompletionListener {
    private static final Logger logger = LogManager.getLogger(SearchBackpressureService.class);
    private volatile Scheduler.Cancellable scheduledFuture;
    private final SearchBackpressureSettings settings;
    private final TaskResourceTrackingService taskResourceTrackingService;
    private final ThreadPool threadPool;
    private final LongSupplier timeNanosSupplier;
    private final List<NodeDuressTracker> nodeDuressTrackers;
    private final Map<Class<? extends SearchBackpressureTask>, List<TaskResourceUsageTracker>> taskTrackers;
    private final Map<Class<? extends SearchBackpressureTask>, SearchBackpressureState> searchBackpressureStates;
    private final TaskManager taskManager;

    public SearchBackpressureService(SearchBackpressureSettings settings, TaskResourceTrackingService taskResourceTrackingService, ThreadPool threadPool, TaskManager taskManager) {
        this(settings, taskResourceTrackingService, threadPool, System::nanoTime, List.of(new NodeDuressTracker(() -> (double)ProcessProbe.getInstance().getProcessCpuPercent() / 100.0 >= settings.getNodeDuressSettings().getCpuThreshold()), new NodeDuressTracker(() -> (double)JvmStats.jvmStats().getMem().getHeapUsedPercent() / 100.0 >= settings.getNodeDuressSettings().getHeapThreshold())), SearchBackpressureService.getTrackers(settings.getSearchTaskSettings()::getCpuTimeNanosThreshold, settings.getSearchTaskSettings()::getHeapVarianceThreshold, settings.getSearchTaskSettings()::getHeapPercentThreshold, settings.getSearchTaskSettings().getHeapMovingAverageWindowSize(), settings.getSearchTaskSettings()::getElapsedTimeNanosThreshold, settings.getClusterSettings(), SearchTaskSettings.SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE), SearchBackpressureService.getTrackers(settings.getSearchShardTaskSettings()::getCpuTimeNanosThreshold, settings.getSearchShardTaskSettings()::getHeapVarianceThreshold, settings.getSearchShardTaskSettings()::getHeapPercentThreshold, settings.getSearchShardTaskSettings().getHeapMovingAverageWindowSize(), settings.getSearchShardTaskSettings()::getElapsedTimeNanosThreshold, settings.getClusterSettings(), SearchShardTaskSettings.SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE), taskManager);
    }

    public SearchBackpressureService(SearchBackpressureSettings settings, TaskResourceTrackingService taskResourceTrackingService, ThreadPool threadPool, LongSupplier timeNanosSupplier, List<NodeDuressTracker> nodeDuressTrackers, List<TaskResourceUsageTracker> searchTaskTrackers, List<TaskResourceUsageTracker> searchShardTaskTrackers, TaskManager taskManager) {
        this.settings = settings;
        this.taskResourceTrackingService = taskResourceTrackingService;
        this.taskResourceTrackingService.addTaskCompletionListener((TaskResourceTrackingService.TaskCompletionListener)this);
        this.threadPool = threadPool;
        this.timeNanosSupplier = timeNanosSupplier;
        this.nodeDuressTrackers = nodeDuressTrackers;
        this.taskManager = taskManager;
        this.searchBackpressureStates = Map.of(SearchTask.class, new SearchBackpressureState(timeNanosSupplier, this.getSettings().getSearchTaskSettings().getCancellationRateNanos(), this.getSettings().getSearchTaskSettings().getCancellationBurst(), this.getSettings().getSearchTaskSettings().getCancellationRatio()), SearchShardTask.class, new SearchBackpressureState(timeNanosSupplier, this.getSettings().getSearchShardTaskSettings().getCancellationRateNanos(), this.getSettings().getSearchShardTaskSettings().getCancellationBurst(), this.getSettings().getSearchShardTaskSettings().getCancellationRatio()));
        this.settings.getSearchTaskSettings().addListener(this.searchBackpressureStates.get(SearchTask.class));
        this.settings.getSearchShardTaskSettings().addListener(this.searchBackpressureStates.get(SearchShardTask.class));
        this.taskTrackers = Map.of(SearchTask.class, searchTaskTrackers, SearchShardTask.class, searchShardTaskTrackers);
    }

    void doRun() {
        SearchBackpressureMode mode = this.getSettings().getMode();
        if (mode == SearchBackpressureMode.DISABLED) {
            return;
        }
        if (!this.isNodeInDuress()) {
            return;
        }
        List<CancellableTask> searchTasks = this.getTaskByType(SearchTask.class);
        List<CancellableTask> searchShardTasks = this.getTaskByType(SearchShardTask.class);
        ArrayList<CancellableTask> cancellableTasks = new ArrayList<CancellableTask>();
        this.taskResourceTrackingService.refreshResourceStats(searchTasks.toArray(new Task[0]));
        this.taskResourceTrackingService.refreshResourceStats(searchShardTasks.toArray(new Task[0]));
        if (HeapUsageTracker.isHeapUsageDominatedBySearch(searchTasks, (double)this.getSettings().getSearchTaskSettings().getTotalHeapPercentThreshold())) {
            cancellableTasks.addAll(searchTasks);
        }
        if (HeapUsageTracker.isHeapUsageDominatedBySearch(searchShardTasks, (double)this.getSettings().getSearchShardTaskSettings().getTotalHeapPercentThreshold())) {
            cancellableTasks.addAll(searchShardTasks);
        }
        if (cancellableTasks.isEmpty()) {
            return;
        }
        for (TaskCancellation taskCancellation : this.getTaskCancellations(cancellableTasks)) {
            boolean ratioLimitReached;
            logger.warn("[{} mode] cancelling task [{}] due to high resource consumption [{}]", (Object)mode.getName(), (Object)taskCancellation.getTask().getId(), (Object)taskCancellation.getReasonString());
            if (mode != SearchBackpressureMode.ENFORCED) continue;
            Class<? extends SearchBackpressureTask> taskType = this.getTaskType((Task)taskCancellation.getTask());
            SearchBackpressureState searchBackpressureState = this.searchBackpressureStates.get(taskType);
            boolean rateLimitReached = !searchBackpressureState.getRateLimiter().request();
            boolean bl = ratioLimitReached = !searchBackpressureState.getRatioLimiter().request();
            if (rateLimitReached && ratioLimitReached) {
                logger.debug("task cancellation limit reached");
                searchBackpressureState.incrementLimitReachedCount();
                break;
            }
            taskCancellation.cancelTaskAndDescendants(this.taskManager);
        }
    }

    Class<? extends SearchBackpressureTask> getTaskType(Task task) {
        if (task instanceof SearchTask) {
            return SearchTask.class;
        }
        if (task instanceof SearchShardTask) {
            return SearchShardTask.class;
        }
        throw new IllegalArgumentException("task must be instance of either SearchTask or SearchShardTask");
    }

    boolean isNodeInDuress() {
        boolean isNodeInDuress = false;
        int numSuccessiveBreaches = this.getSettings().getNodeDuressSettings().getNumSuccessiveBreaches();
        for (NodeDuressTracker tracker : this.nodeDuressTrackers) {
            if (tracker.check() < numSuccessiveBreaches) continue;
            isNodeInDuress = true;
        }
        return isNodeInDuress;
    }

    <T extends CancellableTask> List<CancellableTask> getTaskByType(Class<T> type) {
        return this.taskResourceTrackingService.getResourceAwareTasks().values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toUnmodifiableList());
    }

    TaskCancellation getTaskCancellation(CancellableTask task) {
        ArrayList<TaskCancellation.Reason> reasons = new ArrayList<TaskCancellation.Reason>();
        ArrayList<Runnable> callbacks = new ArrayList<Runnable>();
        Class<? extends SearchBackpressureTask> taskType = this.getTaskType((Task)task);
        List<TaskResourceUsageTracker> trackers = this.taskTrackers.get(taskType);
        for (TaskResourceUsageTracker tracker : trackers) {
            Optional reason = tracker.checkAndMaybeGetCancellationReason((Task)task);
            if (!reason.isPresent()) continue;
            callbacks.add(() -> ((TaskResourceUsageTracker)tracker).incrementCancellations());
            reasons.add((TaskCancellation.Reason)reason.get());
        }
        callbacks.add(this.searchBackpressureStates.get(taskType)::incrementCancellationCount);
        return new TaskCancellation(task, reasons, callbacks);
    }

    List<TaskCancellation> getTaskCancellations(List<? extends CancellableTask> tasks) {
        return tasks.stream().map(this::getTaskCancellation).filter(TaskCancellation::isEligibleForCancellation).sorted(Comparator.reverseOrder()).collect(Collectors.toUnmodifiableList());
    }

    SearchBackpressureSettings getSettings() {
        return this.settings;
    }

    SearchBackpressureState getSearchBackpressureState(Class<? extends SearchBackpressureTask> taskType) {
        return this.searchBackpressureStates.get(taskType);
    }

    public static List<TaskResourceUsageTracker> getTrackers(LongSupplier cpuThresholdSupplier, DoubleSupplier heapVarianceSupplier, DoubleSupplier heapPercentThresholdSupplier, int heapMovingAverageWindowSize, LongSupplier ElapsedTimeNanosSupplier, ClusterSettings clusterSettings, Setting<Integer> windowSizeSetting) {
        ArrayList<Object> trackers = new ArrayList<Object>();
        trackers.add(new CpuUsageTracker(cpuThresholdSupplier));
        if (HeapUsageTracker.isHeapTrackingSupported()) {
            trackers.add(new HeapUsageTracker(heapVarianceSupplier, heapPercentThresholdSupplier, heapMovingAverageWindowSize, clusterSettings, windowSizeSetting));
        } else {
            logger.warn("heap size couldn't be determined");
        }
        trackers.add(new ElapsedTimeTracker(ElapsedTimeNanosSupplier, System::nanoTime));
        return Collections.unmodifiableList(trackers);
    }

    public void onTaskCompleted(Task task) {
        if (this.getSettings().getMode() == SearchBackpressureMode.DISABLED) {
            return;
        }
        if (!(task instanceof SearchBackpressureTask)) {
            return;
        }
        CancellableTask cancellableTask = (CancellableTask)task;
        Class<? extends SearchBackpressureTask> taskType = this.getTaskType(task);
        if (!cancellableTask.isCancelled()) {
            this.searchBackpressureStates.get(taskType).incrementCompletionCount();
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        List<TaskResourceUsageTracker> trackers = this.taskTrackers.get(taskType);
        for (TaskResourceUsageTracker tracker : trackers) {
            try {
                tracker.update(task);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                this.doRun();
            }
            catch (Exception e) {
                logger.debug("failure in search search backpressure", (Throwable)e);
            }
        }, this.getSettings().getInterval(), "generic");
    }

    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    protected void doClose() throws IOException {
    }

    public SearchBackpressureStats nodeStats() {
        List<CancellableTask> searchTasks = this.getTaskByType(SearchTask.class);
        List<CancellableTask> searchShardTasks = this.getTaskByType(SearchShardTask.class);
        SearchTaskStats searchTaskStats = new SearchTaskStats(this.searchBackpressureStates.get(SearchTask.class).getCancellationCount(), this.searchBackpressureStates.get(SearchTask.class).getLimitReachedCount(), this.searchBackpressureStates.get(SearchTask.class).getCompletionCount(), this.taskTrackers.get(SearchTask.class).stream().collect(Collectors.toUnmodifiableMap(t -> TaskResourceUsageTrackerType.fromName((String)t.name()), t -> t.stats(searchTasks))));
        SearchShardTaskStats searchShardTaskStats = new SearchShardTaskStats(this.searchBackpressureStates.get(SearchShardTask.class).getCancellationCount(), this.searchBackpressureStates.get(SearchShardTask.class).getLimitReachedCount(), this.searchBackpressureStates.get(SearchShardTask.class).getCompletionCount(), this.taskTrackers.get(SearchShardTask.class).stream().collect(Collectors.toUnmodifiableMap(t -> TaskResourceUsageTrackerType.fromName((String)t.name()), t -> t.stats(searchShardTasks))));
        return new SearchBackpressureStats(searchTaskStats, searchShardTaskStats, this.getSettings().getMode());
    }
}

