/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import io.skylite.core.search.rescore.RescoreContext;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;

public final class ExplainPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(final FetchContext context) {
        if (!context.explain()) {
            return null;
        }
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                int topLevelDocId = hitContext.hit().docId();
                Explanation explanation = context.searcher().explain(context.query(), topLevelDocId);
                for (RescoreContext rescore : context.rescore()) {
                    explanation = rescore.rescorer().explain(topLevelDocId, (IndexSearcher)context.searcher(), rescore, explanation);
                }
                hitContext.hit().explanation(explanation);
            }
        };
    }
}

