/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import io.skylite.common.lease.Releasable;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.search.RescoreDocIds;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.internal.ReaderContext;
import io.skylite.core.search.internal.ScrollContext;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;

public class LegacyReaderContext
extends ReaderContext {
    private final ShardSearchRequest shardSearchRequest;
    private final ScrollContext scrollContext;
    private final Engine.Searcher searcher;
    private AggregatedDfs aggregatedDfs;
    private RescoreDocIds rescoreDocIds;

    public LegacyReaderContext(ShardSearchContextId id, IndexService indexService, IndexShard indexShard, Engine.SearcherSupplier reader, ShardSearchRequest shardSearchRequest, long keepAliveInMillis) {
        super(id, (BaseIndexService)indexService, (BaseIndexShard)indexShard, reader, keepAliveInMillis, false);
        assert (shardSearchRequest.readerId() == null);
        assert (shardSearchRequest.keepAlive() == null);
        this.shardSearchRequest = Objects.requireNonNull(shardSearchRequest);
        if (shardSearchRequest.scroll() != null) {
            Engine.Searcher delegate = this.searcherSupplier.acquireSearcher("search");
            this.addOnClose((Releasable)delegate);
            this.searcher = new Engine.Searcher(delegate.source(), (IndexReader)delegate.getDirectoryReader(), delegate.getSimilarity(), delegate.getQueryCache(), delegate.getQueryCachingPolicy(), () -> {});
            this.scrollContext = new ScrollContext();
        } else {
            this.scrollContext = null;
            this.searcher = null;
        }
    }

    public Engine.Searcher acquireSearcher(String source) {
        if (this.scrollContext != null) {
            assert ("search".equals(source)) : "scroll context should not acquire searcher for " + source;
            return this.searcher;
        }
        return super.acquireSearcher(source);
    }

    public ShardSearchRequest getShardSearchRequest(ShardSearchRequest other) {
        return this.shardSearchRequest;
    }

    public ScrollContext scrollContext() {
        return this.scrollContext;
    }

    public AggregatedDfs getAggregatedDfs(AggregatedDfs other) {
        return this.aggregatedDfs;
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    public RescoreDocIds getRescoreDocIds(RescoreDocIds other) {
        return this.rescoreDocIds;
    }

    public void setRescoreDocIds(RescoreDocIds rescoreDocIds) {
        this.rescoreDocIds = rescoreDocIds;
    }

    public boolean singleSession() {
        return this.scrollContext == null || this.scrollContext.scroll == null;
    }
}

