/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import io.skylite.core.action.search.SearchType;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.BucketCollectorProcessor;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.search.RescoreDocIds;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.search.dfs.DfsSearchResult;
import io.skylite.core.search.fetch.FetchSearchResult;
import io.skylite.core.search.fetch.subphase.FetchDocValuesContext;
import io.skylite.core.search.fetch.subphase.FetchFieldsContext;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.fetch.subphase.ScriptFieldsContext;
import io.skylite.core.search.fetch.subphase.highlight.SearchHighlightContext;
import io.skylite.core.search.internal.ReaderContext;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.nested.NestedDocuments;
import io.skylite.core.search.rescore.RescoreContext;
import io.skylite.core.search.suggest.SuggestionSearchContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.fetch.subphase.InnerHitsContext;

public abstract class SearchContext
extends SearchExecutionContext {
    public static final BucketCollectorProcessor NO_OP_BUCKET_COLLECTOR_PROCESSOR = new BucketCollectorProcessor(){

        public void processPostCollection(Collector collectorTree) {
        }

        public List<Aggregator> toAggregators(Collection<Collector> collectors) {
            throw new IllegalStateException("Unexpected toAggregators call on NO_OP_BUCKET_COLLECTOR_PROCESSOR");
        }
    };
    private InnerHitsContext innerHitsContext;

    protected SearchContext() {
    }

    public abstract boolean isCancelled();

    public abstract String source();

    public abstract SearchType searchType();

    public abstract void addSearchExt(SearchExtBuilder var1);

    public abstract SearchExtBuilder getSearchExt(String var1);

    public abstract SearchHighlightContext highlight();

    public abstract void highlight(SearchHighlightContext var1);

    public InnerHitsContext innerHits() {
        if (this.innerHitsContext == null) {
            this.innerHitsContext = new InnerHitsContext();
        }
        return this.innerHitsContext;
    }

    public abstract void suggest(SuggestionSearchContext var1);

    public abstract void addRescore(RescoreContext var1);

    public final RescoreDocIds rescoreDocIds() {
        List rescore = this.rescore();
        if (rescore == null) {
            return RescoreDocIds.EMPTY;
        }
        HashMap<Integer, Set> rescoreDocIds = null;
        for (int i = 0; i < rescore.size(); ++i) {
            Set docIds = ((RescoreContext)rescore.get(i)).getRescoredDocs();
            if (docIds == null || docIds.isEmpty()) continue;
            if (rescoreDocIds == null) {
                rescoreDocIds = new HashMap<Integer, Set>();
            }
            rescoreDocIds.put(i, docIds);
        }
        return rescoreDocIds == null ? RescoreDocIds.EMPTY : new RescoreDocIds(rescoreDocIds);
    }

    public final void assignRescoreDocIds(RescoreDocIds rescoreDocIds) {
        List rescore = this.rescore();
        if (rescore != null) {
            for (int i = 0; i < rescore.size(); ++i) {
                Set docIds = rescoreDocIds.getId(i);
                if (docIds == null) continue;
                ((RescoreContext)rescore.get(i)).setRescoredDocs(docIds);
            }
        }
    }

    public abstract boolean hasScriptFields();

    public abstract ScriptFieldsContext scriptFields();

    public abstract boolean sourceRequested();

    public abstract boolean hasFetchSourceContext();

    public abstract FetchSourceContext fetchSourceContext();

    public abstract SearchContext fetchSourceContext(FetchSourceContext var1);

    public abstract FetchDocValuesContext docValuesContext();

    public abstract SearchContext docValuesContext(FetchDocValuesContext var1);

    public abstract FetchFieldsContext fetchFieldsContext();

    public abstract SearchContext fetchFieldsContext(FetchFieldsContext var1);

    public abstract MapperService mapperService();

    public abstract SearchContext parsedQuery(ParsedQuery var1);

    public abstract ParsedQuery parsedQuery();

    public abstract boolean explain();

    public abstract void explain(boolean var1);

    public abstract void groupStats(List<String> var1);

    public abstract boolean version();

    public abstract void version(boolean var1);

    public abstract boolean seqNoAndPrimaryTerm();

    public abstract void seqNoAndPrimaryTerm(boolean var1);

    public abstract int[] docIdsToLoad();

    public abstract int docIdsToLoadSize();

    public abstract SearchContext docIdsToLoad(int[] var1, int var2);

    public abstract DfsSearchResult dfsResult();

    public abstract NestedDocuments getNestedDocuments();

    public abstract FetchPhase fetchPhase();

    public abstract FetchSearchResult fetchResult();

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.shardTarget());
        if (this.searchType() != SearchType.DEFAULT) {
            result.append("searchType=[").append(this.searchType()).append("]");
        }
        if (this.scrollContext() != null) {
            if (this.scrollContext().scroll != null) {
                result.append("scroll=[").append(this.scrollContext().scroll.keepAlive()).append("]");
            } else {
                result.append("scroll=[null]");
            }
        }
        result.append(" query=[").append(this.query()).append("]");
        return result.toString();
    }

    public abstract ReaderContext readerContext();
}

