/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.snapshots;

import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RerouteService;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardRoutingState;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.Priority;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.snapshots.SnapshotShard;
import io.skylite.core.snapshots.SnapshotShardSizeInfo;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.snapshots.SnapshotsInfoService;

public class InternalSnapshotsInfoService
implements ClusterStateListener,
SnapshotsInfoService {
    public static final Setting<Integer> INTERNAL_SNAPSHOT_INFO_MAX_CONCURRENT_FETCHES_SETTING = Setting.intSetting((String)"cluster.snapshot.info.max_concurrent_fetches", (int)5, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(InternalSnapshotsInfoService.class);
    private static final ActionListener<ClusterState> REROUTE_LISTENER = ActionListenerHelper.wrap(r -> logger.trace("reroute after snapshot shard size update completed"), e -> logger.debug("reroute after snapshot shard size update failed", (Throwable)e));
    private final ThreadPool threadPool;
    private final Supplier<RepositoriesService> repositoriesService;
    private final Supplier<RerouteService> rerouteService;
    private volatile Map<SnapshotShard, Long> knownSnapshotShards;
    private volatile boolean isMaster;
    private final Set<SnapshotShard> unknownSnapshotShards;
    private final Queue<SnapshotShard> queue;
    private final Set<SnapshotShard> failedSnapshotShards;
    private volatile int maxConcurrentFetches;
    private int activeFetches;
    private final Object mutex;

    public InternalSnapshotsInfoService(Settings settings, ClusterService clusterService, Supplier<RepositoriesService> repositoriesServiceSupplier, Supplier<RerouteService> rerouteServiceSupplier) {
        this.threadPool = clusterService.getClusterApplierService().threadPool();
        this.repositoriesService = repositoriesServiceSupplier;
        this.rerouteService = rerouteServiceSupplier;
        this.knownSnapshotShards = Map.of();
        this.unknownSnapshotShards = new LinkedHashSet<SnapshotShard>();
        this.failedSnapshotShards = new LinkedHashSet<SnapshotShard>();
        this.queue = new LinkedList<SnapshotShard>();
        this.mutex = new Object();
        this.activeFetches = 0;
        this.maxConcurrentFetches = (Integer)INTERNAL_SNAPSHOT_INFO_MAX_CONCURRENT_FETCHES_SETTING.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_SNAPSHOT_INFO_MAX_CONCURRENT_FETCHES_SETTING, this::setMaxConcurrentFetches);
        if (DiscoveryNode.isClusterManagerNode((Settings)settings)) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    private void setMaxConcurrentFetches(Integer maxConcurrentFetches) {
        this.maxConcurrentFetches = maxConcurrentFetches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotShardSizeInfo snapshotShardSizes() {
        Object object = this.mutex;
        synchronized (object) {
            HashMap<SnapshotShard, Long> snapshotShardSizes = new HashMap<SnapshotShard, Long>(this.knownSnapshotShards);
            if (!this.failedSnapshotShards.isEmpty()) {
                for (SnapshotShard snapshotShard : this.failedSnapshotShards) {
                    Long previous = snapshotShardSizes.put(snapshotShard, -1L);
                    assert (previous == null) : "snapshot shard size already known for " + String.valueOf(snapshotShard);
                }
            }
            return new SnapshotShardSizeInfo(snapshotShardSizes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterChanged(ClusterStateChangedEvent event) {
        if (event.localNodeClusterManager()) {
            Set<SnapshotShard> onGoingSnapshotRecoveries = InternalSnapshotsInfoService.listOfSnapshotShards(event.state());
            int unknownShards = 0;
            Object object = this.mutex;
            synchronized (object) {
                this.isMaster = true;
                for (SnapshotShard snapshotShard : onGoingSnapshotRecoveries) {
                    if (this.knownSnapshotShards.containsKey(snapshotShard) || this.failedSnapshotShards.contains(snapshotShard) || !this.unknownSnapshotShards.add(snapshotShard)) continue;
                    this.queue.add(snapshotShard);
                    ++unknownShards;
                }
                this.cleanUpSnapshotShardSizes(onGoingSnapshotRecoveries);
            }
            int nbFetchers = Math.min(unknownShards, this.maxConcurrentFetches);
            for (int i = 0; i < nbFetchers; ++i) {
                this.fetchNextSnapshotShard();
            }
        } else if (event.previousState().nodes().isLocalNodeElectedClusterManager()) {
            Object object = this.mutex;
            synchronized (object) {
                SnapshotShard snapshotShard;
                this.knownSnapshotShards = Map.of();
                this.failedSnapshotShards.clear();
                this.isMaster = false;
                while ((snapshotShard = this.queue.poll()) != null) {
                    boolean removed = this.unknownSnapshotShards.remove(snapshotShard);
                    assert (removed) : "snapshot shard to remove does not exist " + String.valueOf(snapshotShard);
                }
                assert (this.invariant());
            }
        } else {
            Object object = this.mutex;
            synchronized (object) {
                assert (this.unknownSnapshotShards.isEmpty() || this.unknownSnapshotShards.size() == this.activeFetches);
                assert (this.knownSnapshotShards.isEmpty());
                assert (this.failedSnapshotShards.isEmpty());
                assert (!this.isMaster);
                assert (this.queue.isEmpty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchNextSnapshotShard() {
        Object object = this.mutex;
        synchronized (object) {
            SnapshotShard snapshotShard;
            if (this.activeFetches < this.maxConcurrentFetches && (snapshotShard = this.queue.poll()) != null) {
                ++this.activeFetches;
                this.threadPool.generic().execute((Runnable)((Object)new FetchingSnapshotShardSizeRunnable(snapshotShard)));
            }
            assert (this.invariant());
        }
    }

    private void cleanUpSnapshotShardSizes(Set<SnapshotShard> requiredSnapshotShards) {
        assert (Thread.holdsLock(this.mutex));
        HashMap<SnapshotShard, Long> newSnapshotShardSizes = null;
        for (SnapshotShard shard : this.knownSnapshotShards.keySet()) {
            if (requiredSnapshotShards.contains(shard)) continue;
            if (newSnapshotShardSizes == null) {
                newSnapshotShardSizes = new HashMap<SnapshotShard, Long>(this.knownSnapshotShards);
            }
            newSnapshotShardSizes.remove(shard);
        }
        if (newSnapshotShardSizes != null) {
            this.knownSnapshotShards = Collections.unmodifiableMap(newSnapshotShardSizes);
        }
        this.failedSnapshotShards.retainAll(requiredSnapshotShards);
    }

    private boolean invariant() {
        assert (Thread.holdsLock(this.mutex));
        assert (this.activeFetches >= 0) : "active fetches should be greater than or equal to zero but got: " + this.activeFetches;
        assert (this.activeFetches <= this.maxConcurrentFetches) : this.activeFetches + " <= " + this.maxConcurrentFetches;
        for (SnapshotShard cursor : this.knownSnapshotShards.keySet()) {
            assert (!this.unknownSnapshotShards.contains(cursor)) : "cannot be known and unknown at same time: " + String.valueOf(cursor);
            assert (!this.failedSnapshotShards.contains(cursor)) : "cannot be known and failed at same time: " + String.valueOf(cursor);
        }
        for (SnapshotShard shard : this.unknownSnapshotShards) {
            assert (!this.knownSnapshotShards.keySet().contains(shard)) : "cannot be unknown and known at same time: " + String.valueOf(shard);
            assert (!this.failedSnapshotShards.contains(shard)) : "cannot be unknown and failed at same time: " + String.valueOf(shard);
        }
        for (SnapshotShard shard : this.failedSnapshotShards) {
            assert (!this.knownSnapshotShards.keySet().contains(shard)) : "cannot be failed and known at same time: " + String.valueOf(shard);
            assert (!this.unknownSnapshotShards.contains(shard)) : "cannot be failed and unknown at same time: " + String.valueOf(shard);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numberOfUnknownSnapshotShardSizes() {
        Object object = this.mutex;
        synchronized (object) {
            return this.unknownSnapshotShards.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numberOfFailedSnapshotShardSizes() {
        Object object = this.mutex;
        synchronized (object) {
            return this.failedSnapshotShards.size();
        }
    }

    int numberOfKnownSnapshotShardSizes() {
        return this.knownSnapshotShards.size();
    }

    private static Set<SnapshotShard> listOfSnapshotShards(ClusterState state) {
        HashSet<SnapshotShard> snapshotShards = new HashSet<SnapshotShard>();
        for (ShardRouting shardRouting : state.routingTable().shardsWithState(ShardRoutingState.UNASSIGNED)) {
            if (!shardRouting.primary() || shardRouting.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) continue;
            RecoverySource.SnapshotRecoverySource snapshotRecoverySource = (RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource();
            SnapshotShard snapshotShard = new SnapshotShard(snapshotRecoverySource.snapshot(), snapshotRecoverySource.index(), shardRouting.shardId());
            snapshotShards.add(snapshotShard);
        }
        return Collections.unmodifiableSet(snapshotShards);
    }

    private class FetchingSnapshotShardSizeRunnable
    extends AbstractRunnable {
        private final SnapshotShard snapshotShard;
        private boolean removed;

        FetchingSnapshotShardSizeRunnable(SnapshotShard snapshotShard) {
            this.snapshotShard = snapshotShard;
            this.removed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() throws Exception {
            RepositoriesService repositories = InternalSnapshotsInfoService.this.repositoriesService.get();
            assert (repositories != null);
            Repository repository = repositories.repository(this.snapshotShard.snapshot().getRepository());
            logger.debug("fetching snapshot shard size for {}", (Object)this.snapshotShard);
            long snapshotShardSize = repository.getShardSnapshotStatus(this.snapshotShard.snapshot().getSnapshotId(), this.snapshotShard.index(), this.snapshotShard.shardId()).asCopy().getTotalSize();
            logger.debug("snapshot shard size for {}: {} bytes", (Object)this.snapshotShard, (Object)snapshotShardSize);
            boolean updated = false;
            Object object = InternalSnapshotsInfoService.this.mutex;
            synchronized (object) {
                this.removed = InternalSnapshotsInfoService.this.unknownSnapshotShards.remove(this.snapshotShard);
                assert (this.removed) : "snapshot shard to remove does not exist " + snapshotShardSize;
                if (InternalSnapshotsInfoService.this.isMaster) {
                    HashMap<SnapshotShard, Long> newSnapshotShardSizes = new HashMap<SnapshotShard, Long>(InternalSnapshotsInfoService.this.knownSnapshotShards);
                    boolean bl = updated = newSnapshotShardSizes.put(this.snapshotShard, snapshotShardSize) == null;
                    assert (updated) : "snapshot shard size already exists for " + String.valueOf(this.snapshotShard);
                    InternalSnapshotsInfoService.this.knownSnapshotShards = Collections.unmodifiableMap(newSnapshotShardSizes);
                }
                --InternalSnapshotsInfoService.this.activeFetches;
                assert (InternalSnapshotsInfoService.this.invariant());
            }
            if (updated) {
                InternalSnapshotsInfoService.this.rerouteService.get().reroute("snapshot shard size updated", Priority.HIGH, REROUTE_LISTENER);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(Exception e) {
            logger.warn(() -> new ParameterizedMessage("failed to retrieve shard size for {}", (Object)this.snapshotShard), (Throwable)e);
            boolean failed = false;
            Object object = InternalSnapshotsInfoService.this.mutex;
            synchronized (object) {
                if (InternalSnapshotsInfoService.this.isMaster) {
                    failed = InternalSnapshotsInfoService.this.failedSnapshotShards.add(this.snapshotShard);
                    assert (failed) : "snapshot shard size already failed for " + String.valueOf(this.snapshotShard);
                }
                if (!this.removed) {
                    InternalSnapshotsInfoService.this.unknownSnapshotShards.remove(this.snapshotShard);
                }
                --InternalSnapshotsInfoService.this.activeFetches;
                assert (InternalSnapshotsInfoService.this.invariant());
            }
            if (failed) {
                InternalSnapshotsInfoService.this.rerouteService.get().reroute("snapshot shard size failed", Priority.HIGH, REROUTE_LISTENER);
            }
        }

        public void onAfter() {
            InternalSnapshotsInfoService.this.fetchNextSnapshotShard();
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(INTERNAL_SNAPSHOT_INFO_MAX_CONCURRENT_FETCHES_SETTING);
        }
    }
}

