/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.snapshots;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.ArrayUtils;
import io.skylite.common.util.set.Sets;
import io.skylite.core.FeatureFlags;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.ClusterInfo;
import io.skylite.core.cluster.RestoreInProgress;
import io.skylite.core.cluster.SnapshotDeletionsInProgress;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexTemplateMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.cluster.state.ClusterStateTaskListener;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.Priority;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.snapshots.IndexShardSnapshotStatus;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.indices.IndicesServiceSettings;
import io.skylite.core.node.RemoteStoreNodeAttribute;
import io.skylite.core.node.RemoteStoreNodeService;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryData;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.snapshots.BaseRestoreService;
import io.skylite.core.snapshots.ConcurrentSnapshotExecutionException;
import io.skylite.core.snapshots.RestoreCompletionResponse;
import io.skylite.core.snapshots.RestoreInfo;
import io.skylite.core.snapshots.Snapshot;
import io.skylite.core.snapshots.SnapshotId;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotShardFailure;
import io.skylite.core.snapshots.SnapshotUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.node.Node;
import org.opensearch.snapshots.SnapshotRestoreException;

public class RestoreService
extends BaseRestoreService
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(RestoreService.class);
    private static final Set<String> USER_UNMODIFIABLE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date", "index.history.uuid", "index.remote_store.enabled", "index.remote_store.segment.repository", "index.remote_store.translog.repository"}));
    private static final Set<String> USER_UNREMOVABLE_SETTINGS;
    private static final String REMOTE_STORE_INDEX_SETTINGS_REGEX = "index.remote_store.*";
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final ShardLimitValidator shardLimitValidator;
    private final ClusterSettings clusterSettings;
    private final IndicesService indicesService;
    private final Supplier<ClusterInfo> clusterInfoSupplier;
    private final ClusterManagerTaskThrottler.ThrottlingKey restoreSnapshotTaskKey;
    private static final CleanRestoreStateTaskExecutor cleanRestoreStateTaskExecutor;

    public RestoreService(ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataIndexUpgradeService metadataIndexUpgradeService, ShardLimitValidator shardLimitValidator, IndicesService indicesService, Supplier<ClusterInfo> clusterInfoSupplier) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        if (DiscoveryNode.isClusterManagerNode((Settings)clusterService.getSettings())) {
            clusterService.addStateApplier((ClusterStateApplier)this);
        }
        this.clusterSettings = clusterService.getClusterSettings();
        this.shardLimitValidator = shardLimitValidator;
        this.indicesService = indicesService;
        this.clusterInfoSupplier = clusterInfoSupplier;
        this.restoreSnapshotTaskKey = clusterService.registerClusterManagerTask("restore-snapshot", true);
    }

    public void restoreSnapshot(final RestoreSnapshotRequest request, ActionListener<RestoreCompletionResponse> listener) {
        try {
            String repositoryName = request.repository();
            Repository repository = this.repositoriesService.repository(repositoryName);
            StepListener repositoryDataListener = new StepListener();
            repository.getRepositoryData((ActionListener)repositoryDataListener);
            repositoryDataListener.whenComplete(repositoryData -> {
                Metadata.Builder metadataBuilder;
                HashMap<String, DataStream> dataStreams;
                String snapshotName = request.snapshot();
                Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
                if (!matchingSnapshotId.isPresent()) {
                    throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot does not exist");
                }
                final SnapshotId snapshotId = matchingSnapshotId.get();
                if (request.snapshotUuid() != null && !request.snapshotUuid().equals(snapshotId.getUUID())) {
                    throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot UUID mismatch: expected [" + request.snapshotUuid() + "] but got [" + snapshotId.getUUID() + "]");
                }
                SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
                final Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
                RestoreService.validateSnapshotRestorable(repositoryName, snapshotInfo);
                Metadata globalMetadata = null;
                ArrayList<String> requestIndices = new ArrayList<String>(Arrays.asList(request.indices()));
                List requestedDataStreams = SnapshotUtils.filterIndices((List)snapshotInfo.dataStreams(), (String[])requestIndices.toArray(new String[0]), (IndicesOptions)IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)true));
                if (requestedDataStreams.isEmpty()) {
                    dataStreams = new HashMap<String, DataStream>();
                } else {
                    globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId);
                    Map dataStreamsInSnapshot = globalMetadata.dataStreams();
                    dataStreams = new HashMap(requestedDataStreams.size());
                    for (String requestedDataStream : requestedDataStreams) {
                        DataStream dataStreamInSnapshot = (DataStream)dataStreamsInSnapshot.get(requestedDataStream);
                        assert (dataStreamInSnapshot != null) : "DataStream [" + requestedDataStream + "] not found in snapshot";
                        dataStreams.put(requestedDataStream, dataStreamInSnapshot);
                    }
                }
                requestIndices.removeAll(dataStreams.keySet());
                Set<String> dataStreamIndices = dataStreams.values().stream().flatMap(ds -> ds.getIndices().stream()).map(Index::getName).collect(Collectors.toSet());
                requestIndices.addAll(dataStreamIndices);
                List indicesInSnapshot = SnapshotUtils.filterIndices((List)snapshotInfo.indices(), (String[])requestIndices.toArray(new String[0]), (IndicesOptions)request.indicesOptions());
                if (request.includeGlobalState()) {
                    if (globalMetadata == null) {
                        globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId);
                    }
                    metadataBuilder = Metadata.builder((Metadata)globalMetadata);
                } else {
                    metadataBuilder = Metadata.builder();
                }
                List indexIdsInSnapshot = repositoryData.resolveIndices(indicesInSnapshot);
                for (IndexId indexId : indexIdsInSnapshot) {
                    metadataBuilder.put(repository.getSnapshotIndexMetaData(repositoryData, snapshotId, indexId), false);
                }
                Metadata metadata = metadataBuilder.build();
                final Map<String, String> indices = RestoreService.renamedIndices(request, indicesInSnapshot, dataStreamIndices);
                this.clusterService.submitStateUpdateTask("restore_snapshot[" + snapshotName + "]", (ClusterStateTaskConfig)new ClusterStateUpdateTask((RepositoryData)repositoryData, metadata, snapshotInfo, repository, dataStreams, (ActionListener)listener){
                    final String restoreUUID = UUIDs.randomBase64UUID();
                    RestoreInfo restoreInfo = null;
                    final /* synthetic */ RepositoryData val$repositoryData;
                    final /* synthetic */ Metadata val$metadata;
                    final /* synthetic */ SnapshotInfo val$snapshotInfo;
                    final /* synthetic */ Repository val$repository;
                    final /* synthetic */ Map val$dataStreams;
                    final /* synthetic */ ActionListener val$listener;
                    {
                        this.val$repositoryData = repositoryData;
                        this.val$metadata = metadata;
                        this.val$snapshotInfo = snapshotInfo;
                        this.val$repository = repository;
                        this.val$dataStreams = map2;
                        this.val$listener = actionListener;
                    }

                    public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                        return RestoreService.this.restoreSnapshotTaskKey;
                    }

                    public ClusterState execute(ClusterState currentState) {
                        Map shards;
                        SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions", (ClusterState.Custom)SnapshotDeletionsInProgress.EMPTY);
                        if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.getSnapshots().contains(snapshotId))) {
                            throw new ConcurrentSnapshotExecutionException(snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + String.valueOf(deletionsInProgress.getEntries().get(0)) + "]");
                        }
                        ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                        Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
                        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                        RoutingTable.Builder rtBuilder = RoutingTable.builder((RoutingTable)currentState.routingTable());
                        boolean isRemoteSnapshot = IndexModuleSettings.Type.REMOTE_SNAPSHOT.match(request.storageType().toString());
                        HashSet<String> aliases = new HashSet<String>();
                        long totalRestorableRemoteIndexesSize = 0L;
                        if (!indices.isEmpty()) {
                            HashMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>();
                            for (Map.Entry entry2 : indices.entrySet()) {
                                Index renamedIndex;
                                boolean isRemoteStoreShallowCopy;
                                String renamedIndexName = (String)entry2.getKey();
                                String index = (String)entry2.getValue();
                                boolean partial = this.checkPartial(index);
                                IndexId snapshotIndexId = this.val$repositoryData.resolveIndexId(index);
                                Settings overrideSettingsInternal = this.getOverrideSettingsInternal();
                                String[] ignoreSettingsInternal = this.getIgnoreSettingsInternal();
                                IndexMetadata snapshotIndexMetadata = this.updateIndexSettings(this.val$metadata.index(index), request.indexSettings(), request.ignoreIndexSettings(), overrideSettingsInternal, ignoreSettingsInternal);
                                if (isRemoteSnapshot) {
                                    snapshotIndexMetadata = RestoreService.addSnapshotToIndexSettings(snapshotIndexMetadata, snapshot, snapshotIndexId);
                                }
                                boolean isSearchableSnapshot = IndexModuleSettings.Type.REMOTE_SNAPSHOT.match(snapshotIndexMetadata.getSettings().get(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.getKey()));
                                boolean bl = isRemoteStoreShallowCopy = Boolean.TRUE.equals(this.val$snapshotInfo.isRemoteStoreIndexShallowCopyEnabled()) && this.val$metadata.index(index).getSettings().getAsBoolean("index.remote_store.enabled", Boolean.valueOf(false)) != false;
                                if (isSearchableSnapshot && isRemoteStoreShallowCopy) {
                                    throw new SnapshotRestoreException(snapshot, "Shallow copy snapshot cannot be restored as searchable snapshot.");
                                }
                                if (isRemoteStoreShallowCopy && !currentState.getNodes().getMinNodeVersion().onOrAfter((Version)OpenSearchVersion.V_2_9_0)) {
                                    throw new SnapshotRestoreException(snapshot, "cannot restore shallow copy snapshot for index [" + index + "] as some of the nodes in cluster have version less than 2.9");
                                }
                                RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(this.restoreUUID, snapshot, this.val$snapshotInfo.version(), snapshotIndexId, isSearchableSnapshot, isRemoteStoreShallowCopy, request.getSourceRemoteStoreRepository());
                                Version minIndexCompatibilityVersion = isSearchableSnapshot && RestoreService.isSearchableSnapshotsExtendedCompatibilityEnabled() ? RemoteStoreSettings.SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY_MINIMUM_VERSION.minimumIndexCompatibilityVersion() : currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                                try {
                                    snapshotIndexMetadata = RestoreService.this.metadataIndexUpgradeService.upgradeIndexMetadata(snapshotIndexMetadata, minIndexCompatibilityVersion);
                                }
                                catch (Exception ex) {
                                    throw new SnapshotRestoreException(snapshot, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                                }
                                IndexMetadata currentIndexMetadata = currentState.metadata().index(renamedIndexName);
                                HashSet<Integer> ignoreShards = new HashSet<Integer>();
                                if (currentIndexMetadata == null) {
                                    boolean isHidden = (Boolean)IndexMetadata.INDEX_HIDDEN_SETTING.get(snapshotIndexMetadata.getSettings());
                                    RestoreService.this.createIndexService.validateIndexName(renamedIndexName, currentState);
                                    RestoreService.this.createIndexService.validateDotIndex(renamedIndexName, isHidden);
                                    RestoreService.this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetadata.getSettings(), false);
                                    IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder((IndexMetadata)snapshotIndexMetadata).state(IndexMetadata.State.OPEN).index(renamedIndexName);
                                    indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", UUIDs.randomBase64UUID()));
                                    RestoreService.this.createIndexService.addRemoteStoreCustomMetadata(indexMdBuilder, false);
                                    RestoreService.this.shardLimitValidator.validateShardLimit(renamedIndexName, snapshotIndexMetadata.getSettings(), currentState);
                                    if (!request.includeAliases() && !snapshotIndexMetadata.getAliases().isEmpty()) {
                                        indexMdBuilder.removeAllAliases();
                                    } else {
                                        for (String alias : snapshotIndexMetadata.getAliases().keySet()) {
                                            aliases.add(alias);
                                        }
                                    }
                                    updatedIndexMetadata = indexMdBuilder.build();
                                    if (partial) {
                                        this.populateIgnoredShards(index, ignoreShards);
                                    }
                                    rtBuilder.addAsNewRestore(updatedIndexMetadata, recoverySource, ignoreShards);
                                    blocks.addBlocks(updatedIndexMetadata);
                                    mdBuilder.put(updatedIndexMetadata, true);
                                    renamedIndex = updatedIndexMetadata.getIndex();
                                } else {
                                    this.validateExistingIndex(currentIndexMetadata, snapshotIndexMetadata, renamedIndexName, partial);
                                    IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder((IndexMetadata)snapshotIndexMetadata).state(IndexMetadata.State.OPEN);
                                    indexMdBuilder.version(Math.max(snapshotIndexMetadata.getVersion(), 1L + currentIndexMetadata.getVersion()));
                                    indexMdBuilder.mappingVersion(Math.max(snapshotIndexMetadata.getMappingVersion(), 1L + currentIndexMetadata.getMappingVersion()));
                                    indexMdBuilder.settingsVersion(Math.max(snapshotIndexMetadata.getSettingsVersion(), 1L + currentIndexMetadata.getSettingsVersion()));
                                    indexMdBuilder.aliasesVersion(Math.max(snapshotIndexMetadata.getAliasesVersion(), 1L + currentIndexMetadata.getAliasesVersion()));
                                    for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                                        indexMdBuilder.primaryTerm(shard, Math.max(snapshotIndexMetadata.primaryTerm(shard), currentIndexMetadata.primaryTerm(shard)));
                                    }
                                    if (!request.includeAliases()) {
                                        if (!snapshotIndexMetadata.getAliases().isEmpty()) {
                                            indexMdBuilder.removeAllAliases();
                                        }
                                        for (String alias : currentIndexMetadata.getAliases().values()) {
                                            indexMdBuilder.putAlias((AliasMetadata)alias);
                                        }
                                    } else {
                                        for (String alias : snapshotIndexMetadata.getAliases().keySet()) {
                                            aliases.add(alias);
                                        }
                                    }
                                    Settings.Builder indexSettingsBuilder = Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", currentIndexMetadata.getIndexUUID());
                                    indexSettingsBuilder.put("index.history.uuid", UUIDs.randomBase64UUID());
                                    indexMdBuilder.settings(indexSettingsBuilder);
                                    updatedIndexMetadata = indexMdBuilder.index(renamedIndexName).build();
                                    rtBuilder.addAsRestore(updatedIndexMetadata, recoverySource);
                                    blocks.updateBlocks(updatedIndexMetadata);
                                    mdBuilder.put(updatedIndexMetadata, true);
                                    renamedIndex = updatedIndexMetadata.getIndex();
                                }
                                for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                                    if (isRemoteSnapshot) {
                                        IndexShardSnapshotStatus.Copy shardStatus = this.val$repository.getShardSnapshotStatus(this.val$snapshotInfo.snapshotId(), snapshotIndexId, new ShardId(this.val$metadata.index(index).getIndex(), shard)).asCopy();
                                        totalRestorableRemoteIndexesSize += shardStatus.getTotalSize();
                                    }
                                    if (!ignoreShards.contains(shard)) {
                                        shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId()));
                                        continue;
                                    }
                                    shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.FAILURE));
                                }
                            }
                            shards = Collections.unmodifiableMap(shardsBuilder);
                            RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(this.restoreUUID, snapshot, RestoreService.overallState((RestoreInProgress.State)RestoreInProgress.State.INIT, (Map)shards), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards);
                            builder.putCustom("restore", (ClusterState.Custom)new RestoreInProgress.Builder((RestoreInProgress)currentState.custom("restore", (ClusterState.Custom)RestoreInProgress.EMPTY)).add(restoreEntry).build());
                        } else {
                            shards = Map.of();
                        }
                        this.checkAliasNameConflicts(indices, aliases);
                        if (isRemoteSnapshot) {
                            this.validateSearchableSnapshotRestorable(totalRestorableRemoteIndexesSize);
                        }
                        HashMap updatedDataStreams = new HashMap(currentState.metadata().dataStreams());
                        updatedDataStreams.putAll(this.val$dataStreams.values().stream().map(ds -> RestoreService.updateDataStream(ds, mdBuilder, request)).collect(Collectors.toMap(DataStream::getName, Function.identity())));
                        mdBuilder.dataStreams(updatedDataStreams);
                        if (request.includeGlobalState()) {
                            if (this.val$metadata.persistentSettings() != null) {
                                Settings settings = this.val$metadata.persistentSettings();
                                RestoreService.this.clusterSettings.validateUpdate(settings);
                                mdBuilder.persistentSettings(settings);
                            }
                            if (this.val$metadata.templates() != null) {
                                for (IndexTemplateMetadata indexTemplateMetadata : this.val$metadata.templates().values()) {
                                    mdBuilder.put(indexTemplateMetadata);
                                }
                            }
                            if (this.val$metadata.customs() != null) {
                                for (Map.Entry entry3 : this.val$metadata.customs().entrySet()) {
                                    if ("repositories".equals(entry3.getKey()) || "data_stream".equals(entry3.getKey())) continue;
                                    mdBuilder.putCustom((String)entry3.getKey(), (Metadata.Custom)entry3.getValue());
                                }
                            }
                        }
                        if (RestoreInProgress.completed(shards)) {
                            this.restoreInfo = new RestoreInfo(snapshotId.getName(), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards.size(), shards.size() - RestoreInProgress.failedShards(shards));
                        }
                        RoutingTable rt = rtBuilder.build();
                        ClusterState clusterState = builder.metadata(mdBuilder).blocks(blocks).routingTable(rt).build();
                        return RestoreService.this.allocationService.reroute(clusterState, "restored snapshot [" + String.valueOf(snapshot) + "]");
                    }

                    private void checkAliasNameConflicts(Map<String, String> renamedIndices, Set<String> aliases) {
                        for (Map.Entry<String, String> renamedIndex : renamedIndices.entrySet()) {
                            if (!aliases.contains(renamedIndex.getKey())) continue;
                            throw new SnapshotRestoreException(snapshot, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
                        }
                    }

                    private String[] getIgnoreSettingsInternal() {
                        String[] indexSettingsToBeIgnored = new String[]{};
                        if (!RemoteStoreNodeAttribute.isRemoteStoreAttributePresent((Settings)RestoreService.this.clusterService.getSettings())) {
                            indexSettingsToBeIgnored = ArrayUtils.concat((String[])indexSettingsToBeIgnored, (String[])new String[]{RestoreService.REMOTE_STORE_INDEX_SETTINGS_REGEX});
                        }
                        return indexSettingsToBeIgnored;
                    }

                    private Settings getOverrideSettingsInternal() {
                        Settings.Builder settingsBuilder = Settings.builder();
                        if (RemoteStoreNodeAttribute.isRemoteStoreAttributePresent((Settings)RestoreService.this.clusterService.getSettings()) || ((Boolean)RestoreService.this.clusterSettings.get(IndicesServiceSettings.CLUSTER_RESTRICT_INDEX_REPLICATION_TYPE_SETTING)).booleanValue() || RemoteStoreNodeService.isMigratingToRemoteStore((ClusterSettings)RestoreService.this.clusterSettings)) {
                            MetadataCreateIndexService.updateReplicationStrategy(settingsBuilder, request.indexSettings(), RestoreService.this.clusterService.getSettings(), null, RestoreService.this.clusterSettings);
                        }
                        MetadataCreateIndexService.updateRemoteStoreSettings(settingsBuilder, RestoreService.this.clusterService.state(), RestoreService.this.clusterSettings, RestoreService.this.clusterService.getSettings(), request.getDescription());
                        return settingsBuilder.build();
                    }

                    private void populateIgnoredShards(String index, Set<Integer> ignoreShards) {
                        for (SnapshotShardFailure failure : this.val$snapshotInfo.shardFailures()) {
                            if (!index.equals(failure.index())) continue;
                            ignoreShards.add(failure.shardId());
                        }
                    }

                    private boolean checkPartial(String index) {
                        if (BaseRestoreService.failed((SnapshotInfo)this.val$snapshotInfo, (String)index)) {
                            if (request.partial()) {
                                return true;
                            }
                            throw new SnapshotRestoreException(snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                        }
                        return false;
                    }

                    private void validateExistingIndex(IndexMetadata currentIndexMetadata, IndexMetadata snapshotIndexMetadata, String renamedIndex, boolean partial) {
                        if (currentIndexMetadata.getState() != IndexMetadata.State.CLOSE) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] because an open index with same name already exists in the cluster. Either close or delete the existing index or restore the index under a different name by providing a rename pattern and replacement name");
                        }
                        if (partial) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
                        }
                        if (currentIndexMetadata.getNumberOfShards() != snapshotIndexMetadata.getNumberOfShards()) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetadata.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetadata.getIndex().getName() + "] with [" + snapshotIndexMetadata.getNumberOfShards() + "] shards");
                        }
                    }

                    private IndexMetadata updateIndexSettings(IndexMetadata indexMetadata, Settings overrideSettings, String[] ignoreSettings, Settings overrideSettingsInternal, String[] ignoreSettingsInternal) {
                        Settings normalizedChangeSettings = Settings.builder().put(overrideSettings).normalizePrefix("index.").build();
                        if (((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetadata.getSettings())).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(overrideSettings) && !((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(overrideSettings)).booleanValue()) {
                            throw new SnapshotRestoreException(snapshot, "cannot disable setting [" + IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey() + "] on restore");
                        }
                        IndexMetadata.Builder builder = IndexMetadata.builder((IndexMetadata)indexMetadata);
                        Settings settings = indexMetadata.getSettings();
                        HashSet<String> keyFilters = new HashSet<String>();
                        ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
                        for (String ignoredSetting : ignoreSettings) {
                            if (!Regex.isSimpleMatchPattern((String)ignoredSetting)) {
                                if (USER_UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                                    throw new SnapshotRestoreException(snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                                }
                                keyFilters.add(ignoredSetting);
                                continue;
                            }
                            simpleMatchPatterns.add(ignoredSetting);
                        }
                        for (String ignoredSetting : ignoreSettingsInternal) {
                            if (!Regex.isSimpleMatchPattern((String)ignoredSetting)) {
                                keyFilters.add(ignoredSetting);
                                continue;
                            }
                            simpleMatchPatterns.add(ignoredSetting);
                        }
                        Predicate<String> settingsFilter = k -> {
                            if (!USER_UNREMOVABLE_SETTINGS.contains(k)) {
                                for (String filterKey : keyFilters) {
                                    if (!k.equals(filterKey)) continue;
                                    return false;
                                }
                                for (String pattern : simpleMatchPatterns) {
                                    if (!Regex.simpleMatch((String)pattern, (String)k)) continue;
                                    return false;
                                }
                            }
                            return true;
                        };
                        Settings.Builder settingsBuilder = Settings.builder().put(settings.filter(settingsFilter)).put(normalizedChangeSettings.filter(k -> {
                            if (USER_UNMODIFIABLE_SETTINGS.contains(k)) {
                                throw new SnapshotRestoreException(snapshot, "cannot modify setting [" + k + "] on restore");
                            }
                            return true;
                        }));
                        if (overrideSettingsInternal != null) {
                            settingsBuilder.put(overrideSettingsInternal).normalizePrefix("index.");
                        }
                        settingsBuilder.remove(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
                        return builder.settings(settingsBuilder).build();
                    }

                    private void validateSearchableSnapshotRestorable(long totalRestorableRemoteIndexesSize) {
                        ClusterInfo clusterInfo = RestoreService.this.clusterInfoSupplier.get();
                        double remoteDataToFileCacheRatio = (Double)FileCache.DATA_TO_FILE_CACHE_SIZE_RATIO_SETTING.get(RestoreService.this.clusterService.getSettings());
                        Map nodeFileCacheStats = clusterInfo.getNodeFileCacheStats();
                        if (nodeFileCacheStats.isEmpty() || remoteDataToFileCacheRatio <= (double)0.01f) {
                            return;
                        }
                        long totalNodeFileCacheSize = clusterInfo.getNodeFileCacheStats().values().stream().map(fileCacheStats -> fileCacheStats.getTotal().getBytes()).mapToLong(Long::longValue).sum();
                        Predicate<ShardRouting> isRemoteSnapshotShard = shardRouting -> shardRouting.primary() && RestoreService.this.indicesService.indexService(shardRouting.index()).getIndexSettings().isRemoteSnapshot();
                        ShardsIterator shardsIterator = RestoreService.this.clusterService.state().routingTable().allShardsSatisfyingPredicate(isRemoteSnapshotShard);
                        long totalRestoredRemoteIndexesSize = shardsIterator.getShardRoutings().stream().map(arg_0 -> ((ClusterInfo)clusterInfo).getShardSize(arg_0)).mapToLong(Long::longValue).sum();
                        if ((double)(totalRestoredRemoteIndexesSize + totalRestorableRemoteIndexesSize) > remoteDataToFileCacheRatio * (double)totalNodeFileCacheSize) {
                            throw new SnapshotRestoreException(snapshot, "Size of the indexes to be restored exceeds the file cache bounds. Increase the file cache capacity on the cluster nodes using " + Node.NODE_SEARCH_CACHE_SIZE_SETTING.getKey() + " setting.");
                        }
                    }

                    public void onFailure(String source, Exception e) {
                        logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)snapshotId), (Throwable)e);
                        this.val$listener.onFailure(e);
                    }

                    public TimeValue timeout() {
                        return request.clusterManagerNodeTimeout();
                    }

                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        this.val$listener.onResponse((Object)new RestoreCompletionResponse(this.restoreUUID, snapshot, this.restoreInfo));
                    }
                });
            }, arg_0 -> listener.onFailure(arg_0));
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repository() + ":" + request.snapshot())), (Throwable)e);
            listener.onFailure(e);
        }
    }

    static DataStream updateDataStream(DataStream dataStream, Metadata.Builder metadata, RestoreSnapshotRequest request) {
        String dataStreamName = dataStream.getName();
        if (request.renamePattern() != null && request.renameReplacement() != null) {
            dataStreamName = dataStreamName.replaceAll(request.renamePattern(), request.renameReplacement());
        }
        List updatedIndices = dataStream.getIndices().stream().map(i -> metadata.get(RestoreService.renameIndex(i.getName(), request, true)).getIndex()).collect(Collectors.toList());
        return new DataStream(dataStreamName, dataStream.getTimeStampField(), updatedIndices, dataStream.getGeneration());
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
        for (RestoreInProgress.Entry entry : oldRestore) {
            HashMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (Map.Entry cursor : entry.shards().entrySet()) {
                ShardId shardId = (ShardId)cursor.getKey();
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                Map shards = Collections.unmodifiableMap(shardsBuilder);
                builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), BaseRestoreService.overallState((RestoreInProgress.State)RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            builder.add(entry);
        }
        if (changesMade) {
            return builder.build();
        }
        return oldRestore;
    }

    private void cleanupRestoreState(ClusterStateChangedEvent event) {
        for (RestoreInProgress.Entry entry : (RestoreInProgress)event.state().custom("restore", (ClusterState.Custom)RestoreInProgress.EMPTY)) {
            if (!entry.state().completed()) continue;
            assert (RestoreInProgress.completed((Map)entry.shards())) : "state says completed but restore entries are not";
            this.clusterService.submitStateUpdateTask("clean up snapshot restore state", (Object)new CleanRestoreStateTaskExecutor.Task(entry.uuid()), ClusterStateTaskConfig.build((Priority)Priority.URGENT), (ClusterStateTaskExecutor)cleanRestoreStateTaskExecutor, (ClusterStateTaskListener)cleanRestoreStateTaskExecutor);
        }
    }

    private static Map<String, String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices, Set<String> dataStreamIndices) {
        HashMap<String, String> renamedIndices = new HashMap<String, String>();
        for (String index : filteredIndices) {
            String renamedIndex = RestoreService.renameIndex(index, request, dataStreamIndices.contains(index));
            String previousIndex = renamedIndices.put(renamedIndex, index);
            if (previousIndex == null) continue;
            throw new SnapshotRestoreException(request.repository(), request.snapshot(), "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return Collections.unmodifiableMap(renamedIndices);
    }

    private static String renameIndex(String index, RestoreSnapshotRequest request, boolean partOfDataStream) {
        Object renamedIndex = index;
        if (request.renameReplacement() != null && request.renamePattern() != null) {
            boolean bl = partOfDataStream = partOfDataStream && index.startsWith(".ds-");
            if (partOfDataStream) {
                index = index.substring(".ds-".length());
            }
            renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            if (partOfDataStream) {
                renamedIndex = ".ds-" + (String)renamedIndex;
            }
        }
        return renamedIndex;
    }

    private static void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + String.valueOf(snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with OpenSearch version [" + String.valueOf(snapshotInfo.version()) + "] which is higher than the version of this node [" + String.valueOf(Version.CURRENT) + "]");
        }
    }

    public static Set<Index> restoringIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (RestoreInProgress.Entry entry : (RestoreInProgress)currentState.custom("restore", (ClusterState.Custom)RestoreInProgress.EMPTY)) {
            for (Map.Entry shard : entry.shards().entrySet()) {
                Index index = ((ShardId)shard.getKey()).getIndex();
                if (!indicesToCheck.contains(index) || ((RestoreInProgress.ShardRestoreStatus)shard.getValue()).state().completed() || currentState.getMetadata().index(index) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    public void applyClusterState(ClusterStateChangedEvent event) {
        try {
            if (event.localNodeClusterManager()) {
                this.cleanupRestoreState(event);
            }
        }
        catch (Exception t) {
            logger.warn("Failed to update restore state ", (Throwable)t);
        }
    }

    private static IndexMetadata addSnapshotToIndexSettings(IndexMetadata metadata, Snapshot snapshot, IndexId indexId) {
        Settings newSettings = Settings.builder().put(metadata.getSettings()).put(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.getKey(), IndexModuleSettings.Type.REMOTE_SNAPSHOT.getSettingsKey()).put(IndexSettings.SEARCHABLE_SNAPSHOT_REPOSITORY.getKey(), snapshot.getRepository()).put(IndexSettings.SEARCHABLE_SNAPSHOT_ID_UUID.getKey(), snapshot.getSnapshotId().getUUID()).put(IndexSettings.SEARCHABLE_SNAPSHOT_ID_NAME.getKey(), snapshot.getSnapshotId().getName()).put(IndexSettings.SEARCHABLE_SNAPSHOT_INDEX_ID.getKey(), indexId.getId()).build();
        return IndexMetadata.builder((IndexMetadata)metadata).settings(newSettings).build();
    }

    private static boolean isSearchableSnapshotsExtendedCompatibilityEnabled() {
        return Version.CURRENT.after((Version)OpenSearchVersion.V_2_4_0) && FeatureFlags.isEnabled((String)"lucenia.experimental.feature.searchable_snapshot.extended_compatibility.enabled");
    }

    static {
        HashSet<String> unremovable = new HashSet<String>(USER_UNMODIFIABLE_SETTINGS.size() + 4);
        unremovable.addAll(USER_UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        unremovable.add("index.version.upgraded");
        USER_UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
        cleanRestoreStateTaskExecutor = new CleanRestoreStateTaskExecutor();
    }

    static class CleanRestoreStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        CleanRestoreStateTaskExecutor() {
        }

        public ClusterStateTaskExecutor.ClusterStateTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) {
            ClusterStateTaskExecutor.ClusterStateTasksResult.Builder resultBuilder = ClusterStateTaskExecutor.ClusterStateTasksResult.builder().successes(tasks);
            Set completedRestores = tasks.stream().map(e -> e.uuid).collect(Collectors.toSet());
            RestoreInProgress.Builder restoreInProgressBuilder = new RestoreInProgress.Builder();
            boolean changed = false;
            for (RestoreInProgress.Entry entry : (RestoreInProgress)currentState.custom("restore", (ClusterState.Custom)RestoreInProgress.EMPTY)) {
                if (completedRestores.contains(entry.uuid())) {
                    changed = true;
                    continue;
                }
                restoreInProgressBuilder.add(entry);
            }
            if (!changed) {
                return resultBuilder.build(currentState);
            }
            HashMap<String, RestoreInProgress> builder = new HashMap<String, RestoreInProgress>(currentState.getCustoms());
            builder.put("restore", restoreInProgressBuilder.build());
            Map customs = Collections.unmodifiableMap(builder);
            return resultBuilder.build(ClusterState.builder((ClusterState)currentState).customs(customs).build());
        }

        public void onFailure(String source, Exception e) {
            logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        public void onNoLongerClusterManager(String source) {
            logger.debug("no longer cluster-manager while processing restore state update [{}]", (Object)source);
        }

        static class Task {
            final String uuid;

            Task(String uuid) {
                this.uuid = uuid;
            }

            public String toString() {
                return "clean restore state for restore " + this.uuid;
            }
        }
    }
}

