/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.snapshots;

import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.concurrent.GatedCloseable;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.indices.flush.FlushRequest;
import io.skylite.core.cluster.SnapshotsInProgress;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.seqno.SequenceNumbers;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.snapshots.IndexShardSnapshotFailedException;
import io.skylite.core.index.snapshots.IndexShardSnapshotStatus;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.settings.Settings;
import io.skylite.core.snapshots.AbortedSnapshotException;
import io.skylite.core.snapshots.Snapshot;
import io.skylite.core.snapshots.UpdateIndexShardSnapshotStatusRequest;
import io.skylite.core.snapshots.UpdateIndexShardSnapshotStatusResponse;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestDeduplicator;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexCommit;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class SnapshotShardsService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SnapshotShardsService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> shardSnapshots = new HashMap<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>();
    private final TransportRequestDeduplicator<UpdateIndexShardSnapshotStatusRequest> remoteFailedRequestDeduplicator = new TransportRequestDeduplicator();

    public SnapshotShardsService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService, IndicesService indicesService) {
        this.indicesService = indicesService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = transportService.getThreadPool();
        if (DiscoveryNode.isDataNode((Settings)settings)) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
        this.clusterService.removeListener((ClusterStateListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterChanged(ClusterStateChangedEvent event) {
        try {
            SnapshotsInProgress previousSnapshots = (SnapshotsInProgress)event.previousState().custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY);
            SnapshotsInProgress currentSnapshots = (SnapshotsInProgress)event.state().custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY);
            if (!previousSnapshots.equals((Object)currentSnapshots)) {
                Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
                synchronized (map) {
                    this.cancelRemoved(currentSnapshots);
                    this.startNewSnapshots(currentSnapshots);
                }
            }
            String previousClusterManagerNodeId = event.previousState().nodes().getClusterManagerNodeId();
            String currentMasterNodeId = event.state().nodes().getClusterManagerNodeId();
            if (currentMasterNodeId != null && !currentMasterNodeId.equals(previousClusterManagerNodeId)) {
                this.syncShardStatsOnNewMaster(event);
            }
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            logger.warn("Failed to update snapshot state ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeIndexShardClosed(ShardId shardId, @Nullable BaseIndexShard indexShard, Settings indexSettings) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshotShards : this.shardSnapshots.entrySet()) {
                Map<ShardId, IndexShardSnapshotStatus> shards = snapshotShards.getValue();
                if (!shards.containsKey(shardId)) continue;
                logger.debug("[{}] shard closing, abort snapshotting for snapshot [{}]", (Object)shardId, (Object)snapshotShards.getKey().getSnapshotId());
                shards.get(shardId).abortIfNotCompleted("shard is closing, aborting");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ShardId, IndexShardSnapshotStatus> currentSnapshotShards(Snapshot snapshot) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            Map<ShardId, IndexShardSnapshotStatus> current = this.shardSnapshots.get(snapshot);
            return current == null ? null : new HashMap<ShardId, IndexShardSnapshotStatus>(current);
        }
    }

    private void cancelRemoved(SnapshotsInProgress snapshotsInProgress) {
        Iterator<Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>> it = this.shardSnapshots.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> entry = it.next();
            Snapshot snapshot = entry.getKey();
            if (snapshotsInProgress.snapshot(snapshot) != null) continue;
            it.remove();
            for (IndexShardSnapshotStatus snapshotStatus : entry.getValue().values()) {
                snapshotStatus.abortIfNotCompleted("snapshot has been removed in cluster state, aborting");
            }
        }
    }

    private void startNewSnapshots(SnapshotsInProgress snapshotsInProgress) {
        String localNodeId = this.clusterService.localNode().getId();
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            SnapshotsInProgress.State entryState = entry.state();
            if (entry.isClone()) continue;
            if (entryState == SnapshotsInProgress.State.STARTED) {
                HashMap<ShardId, IndexShardSnapshotStatus> startedShards = null;
                Snapshot snapshot = entry.snapshot();
                Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
                for (Map.Entry shard : entry.shards().entrySet()) {
                    ShardId shardId = (ShardId)shard.getKey();
                    SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)shard.getValue();
                    if (shardSnapshotStatus.state() != SnapshotsInProgress.ShardState.INIT || !localNodeId.equals(shardSnapshotStatus.nodeId()) || snapshotShards.containsKey(shardId)) continue;
                    logger.trace("[{}] - Adding shard to the queue", (Object)shardId);
                    if (startedShards == null) {
                        startedShards = new HashMap<ShardId, IndexShardSnapshotStatus>();
                    }
                    startedShards.put(shardId, IndexShardSnapshotStatus.newInitializing((String)shardSnapshotStatus.generation()));
                }
                if (startedShards == null || startedShards.isEmpty()) continue;
                this.shardSnapshots.computeIfAbsent(snapshot, s -> new HashMap()).putAll(startedShards);
                this.startNewShards(entry, (Map<ShardId, IndexShardSnapshotStatus>)startedShards);
                continue;
            }
            if (entryState != SnapshotsInProgress.State.ABORTED) continue;
            Snapshot snapshot = entry.snapshot();
            Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
            for (Map.Entry shard : entry.shards().entrySet()) {
                IndexShardSnapshotStatus snapshotStatus = (IndexShardSnapshotStatus)snapshotShards.get(shard.getKey());
                if (snapshotStatus == null) {
                    if (((SnapshotsInProgress.ShardSnapshotStatus)shard.getValue()).state() != SnapshotsInProgress.ShardState.ABORTED || !localNodeId.equals(((SnapshotsInProgress.ShardSnapshotStatus)shard.getValue()).nodeId())) continue;
                    this.notifyFailedSnapshotShard(snapshot, (ShardId)shard.getKey(), ((SnapshotsInProgress.ShardSnapshotStatus)shard.getValue()).reason());
                    continue;
                }
                snapshotStatus.abortIfNotCompleted("snapshot has been aborted");
            }
        }
    }

    private void startNewShards(SnapshotsInProgress.Entry entry, Map<ShardId, IndexShardSnapshotStatus> startedShards) {
        this.threadPool.executor("snapshot").execute(() -> {
            final Snapshot snapshot = entry.snapshot();
            Map indicesMap = entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity()));
            for (Map.Entry shardEntry : startedShards.entrySet()) {
                final ShardId shardId = (ShardId)shardEntry.getKey();
                final IndexShardSnapshotStatus snapshotStatus = (IndexShardSnapshotStatus)shardEntry.getValue();
                IndexId indexId = (IndexId)indicesMap.get(shardId.getIndexName());
                assert (indexId != null);
                if (this.isRemoteSnapshot(shardId)) {
                    this.notifySuccessfulSnapshotShard(snapshot, shardId, snapshotStatus.generation());
                    continue;
                }
                this.snapshot(shardId, snapshot, indexId, entry.userMetadata(), snapshotStatus, entry.version(), entry.remoteStoreIndexShallowCopy(), new ActionListener<String>(){

                    public void onResponse(String newGeneration) {
                        assert (newGeneration != null);
                        assert (newGeneration.equals(snapshotStatus.generation()));
                        if (logger.isDebugEnabled()) {
                            IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
                            logger.debug("snapshot [{}] completed to [{}] with [{}] at generation [{}]", (Object)snapshot, (Object)snapshot.getRepository(), (Object)lastSnapshotStatus, (Object)snapshotStatus.generation());
                        }
                        SnapshotShardsService.this.notifySuccessfulSnapshotShard(snapshot, shardId, newGeneration);
                    }

                    public void onFailure(Exception e) {
                        String failure;
                        if (e instanceof AbortedSnapshotException) {
                            failure = "aborted";
                            logger.debug(() -> new ParameterizedMessage("[{}][{}] aborted shard snapshot", (Object)shardId, (Object)snapshot), (Throwable)e);
                        } else {
                            failure = SnapshotShardsService.summarizeFailure(e);
                            logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to snapshot shard", (Object)shardId, (Object)snapshot), (Throwable)e);
                        }
                        snapshotStatus.moveToFailed(SnapshotShardsService.this.threadPool.absoluteTimeInMillis(), failure);
                        SnapshotShardsService.this.notifyFailedSnapshotShard(snapshot, shardId, failure);
                    }
                });
            }
        });
    }

    private boolean isRemoteSnapshot(ShardId shardId) {
        IndexShard baseShard;
        IndexShard shard;
        IndexService baseIndexService = this.indicesService.indexService(shardId.getIndex());
        IndexService indexService = baseIndexService;
        if (indexService != null && (shard = (baseShard = indexService.getShardOrNull(shardId.id()))) != null) {
            return shard.isRemoteSnapshot();
        }
        return false;
    }

    static String summarizeFailure(Throwable t) {
        if (t.getCause() == null) {
            return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
        }
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            sb.append(t.getClass().getSimpleName());
            if (t.getMessage() != null) {
                sb.append("[");
                sb.append(t.getMessage());
                sb.append("]");
            }
            if ((t = t.getCause()) == null) continue;
            sb.append("; nested: ");
        }
        return sb.toString();
    }

    private void snapshot(ShardId shardId, Snapshot snapshot, IndexId indexId, Map<String, Object> userMetadata, IndexShardSnapshotStatus snapshotStatus, Version version, boolean remoteStoreIndexShallowCopy, ActionListener<String> listener) {
        block13: {
            try {
                IndexShard baseIndexShard;
                IndexShard indexShard = baseIndexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShardOrNull(shardId.id());
                if (!indexShard.routingEntry().primary()) {
                    throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
                }
                if (indexShard.indexSettings().isSegRepEnabledOrRemoteNode() && !indexShard.isPrimaryMode()) {
                    throw new IndexShardSnapshotFailedException(shardId, "snapshot triggered on a new primary following failover and cannot proceed until promotion is complete");
                }
                if (indexShard.routingEntry().relocating()) {
                    throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
                }
                IndexShardState indexShardState = indexShard.state();
                if (indexShardState == IndexShardState.CREATED || indexShardState == IndexShardState.RECOVERING) {
                    throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
                }
                Repository repository = this.repositoriesService.repository(snapshot.getRepository());
                GatedCloseable wrappedSnapshot = null;
                try {
                    if (remoteStoreIndexShallowCopy && indexShard.indexSettings().isRemoteStoreEnabled()) {
                        long startTime = this.threadPool.relativeTimeInMillis();
                        long primaryTerm = indexShard.getOperationPrimaryTerm();
                        wrappedSnapshot = indexShard.acquireLastIndexCommitAndRefresh(true);
                        IndexCommit snapshotIndexCommit = (IndexCommit)wrappedSnapshot.get();
                        long commitGeneration = snapshotIndexCommit.getGeneration();
                        try {
                            indexShard.acquireLockOnCommitData(snapshot.getSnapshotId().getUUID(), primaryTerm, commitGeneration);
                        }
                        catch (NoSuchFileException e) {
                            wrappedSnapshot.close();
                            logger.warn("Exception while acquiring lock on primaryTerm = {} and generation = {}", (Object)primaryTerm, (Object)commitGeneration);
                            indexShard.flush(new FlushRequest(new String[]{shardId.getIndexName()}).force(true));
                            wrappedSnapshot = indexShard.acquireLastIndexCommit(false);
                            snapshotIndexCommit = (IndexCommit)wrappedSnapshot.get();
                            commitGeneration = snapshotIndexCommit.getGeneration();
                            indexShard.acquireLockOnCommitData(snapshot.getSnapshotId().getUUID(), primaryTerm, commitGeneration);
                        }
                        try {
                            repository.snapshotRemoteStoreIndexShard(indexShard.store(), snapshot.getSnapshotId(), indexId, snapshotIndexCommit, SnapshotShardsService.getShardStateId(indexShard, snapshotIndexCommit), snapshotStatus, primaryTerm, startTime, ActionListenerHelper.runBefore(listener, () -> wrappedSnapshot.close()));
                        }
                        catch (IndexShardSnapshotFailedException e) {
                            logger.error("Shallow Copy Snapshot Failed for Shard [" + indexId.getName() + "][" + shardId.getId() + "] for snapshot " + String.valueOf(snapshot.getSnapshotId()) + ", releasing acquired lock from remote store");
                            indexShard.releaseLockOnCommitData(snapshot.getSnapshotId().getUUID(), primaryTerm, commitGeneration);
                            throw e;
                        }
                        long endTime = this.threadPool.relativeTimeInMillis();
                        logger.debug("Time taken (in milliseconds) to complete shallow copy snapshot, for index " + indexId.getName() + ", shard " + shardId.getId() + " and snapshot " + String.valueOf(snapshot.getSnapshotId()) + " is " + (endTime - startTime));
                        break block13;
                    }
                    wrappedSnapshot = indexShard.acquireLastIndexCommit(true);
                    IndexCommit snapshotIndexCommit = (IndexCommit)wrappedSnapshot.get();
                    repository.snapshotShard(indexShard.store(), indexShard.mapperService(), snapshot.getSnapshotId(), indexId, (IndexCommit)wrappedSnapshot.get(), SnapshotShardsService.getShardStateId(indexShard, snapshotIndexCommit), snapshotStatus, version, userMetadata, ActionListenerHelper.runBefore(listener, () -> wrappedSnapshot.close()));
                }
                catch (Exception e) {
                    IOUtils.close(wrappedSnapshot);
                    throw e;
                }
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    @Nullable
    private static String getShardStateId(IndexShard indexShard, IndexCommit snapshotIndexCommit) throws IOException {
        Map userCommitData = snapshotIndexCommit.getUserData();
        SequenceNumbers.CommitInfo seqNumInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userCommitData.entrySet());
        long maxSeqNo = seqNumInfo.maxSeqNo;
        if (maxSeqNo != seqNumInfo.localCheckpoint || maxSeqNo != indexShard.getLastSyncedGlobalCheckpoint()) {
            return null;
        }
        return (String)userCommitData.get("history_uuid") + "-" + userCommitData.getOrDefault("force_merge_uuid", "na") + "-" + maxSeqNo;
    }

    private void syncShardStatsOnNewMaster(ClusterStateChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        if (snapshotsInProgress == null) {
            return;
        }
        this.remoteFailedRequestDeduplicator.clear();
        for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED || (localShards = this.currentSnapshotShards(snapshot.snapshot())) == null) continue;
            Map masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = (SnapshotsInProgress.ShardSnapshotStatus)masterShards.get(shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                IndexShardSnapshotStatus.Copy indexShardSnapshotStatus = localShard.getValue().asCopy();
                IndexShardSnapshotStatus.Stage stage = indexShardSnapshotStatus.getStage();
                if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                    logger.debug("[{}] new cluster-manager thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifySuccessfulSnapshotShard(snapshot.snapshot(), shardId, localShard.getValue().generation());
                    continue;
                }
                if (stage != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                logger.debug("[{}] new cluster-manager thinks the shard [{}] is not completed but the shard failed locally, updating status on master", (Object)snapshot.snapshot(), (Object)shardId);
                this.notifyFailedSnapshotShard(snapshot.snapshot(), shardId, indexShardSnapshotStatus.getFailure());
            }
        }
    }

    private void notifySuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, String generation) {
        assert (generation != null);
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), SnapshotsInProgress.ShardState.SUCCESS, generation));
    }

    private void notifyFailedSnapshotShard(Snapshot snapshot, ShardId shardId, String failure) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), SnapshotsInProgress.ShardState.FAILED, failure, null));
    }

    private void sendSnapshotShardUpdate(final Snapshot snapshot, ShardId shardId, final SnapshotsInProgress.ShardSnapshotStatus status) {
        this.remoteFailedRequestDeduplicator.executeOnce((TransportRequest)new UpdateIndexShardSnapshotStatusRequest(snapshot, shardId, status), (ActionListener)new ActionListener<Void>(){

            public void onResponse(Void aVoid) {
                logger.trace("[{}] [{}] updated snapshot state", (Object)snapshot, (Object)status);
            }

            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to update snapshot state", (Object)snapshot, (Object)status), (Throwable)e);
            }
        }, (req, reqListener) -> this.transportService.sendRequest(this.transportService.getLocalNode(), "internal:cluster/snapshot/update_snapshot_status", (TransportRequest)req, (TransportResponseHandler)new TransportResponseHandler<UpdateIndexShardSnapshotStatusResponse>(){

            public UpdateIndexShardSnapshotStatusResponse read(StreamInput in) {
                return UpdateIndexShardSnapshotStatusResponse.INSTANCE;
            }

            public void handleResponse(UpdateIndexShardSnapshotStatusResponse response) {
                reqListener.onResponse(null);
            }

            public void handleException(TransportException exp) {
                reqListener.onFailure((Exception)exp);
            }

            public String executor() {
                return "same";
            }
        }));
    }
}

