/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.index.IndexRequestBuilder;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.OriginSettingClient;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.BaseTaskResultsService;
import io.skylite.core.tasks.TaskResult;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TaskResultsService
extends BaseTaskResultsService {
    private static final Logger logger = LogManager.getLogger(TaskResultsService.class);
    static final BackoffPolicy STORE_BACKOFF_POLICY = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)250L), (int)14);
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TaskResultsService(Client client, ThreadPool threadPool) {
        this.client = new OriginSettingClient(client, "tasks");
        this.threadPool = threadPool;
    }

    public void storeResult(TaskResult taskResult, ActionListener<Void> listener) {
        IndexRequestBuilder index = this.client.prepareIndex(".tasks").setId(taskResult.getTask().getTaskId().toString());
        try (XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)MediaTypeRegistry.INDEX_SOURCE_CONTENT_TYPE);){
            taskResult.toXContent(builder, ToXContent.EMPTY_PARAMS);
            index.setSource(builder);
        }
        catch (IOException e) {
            throw new SkyliteException("Couldn't convert task result to XContent for [{}]", (Throwable)e, new Object[]{taskResult.getTask()});
        }
        this.doStoreResult(STORE_BACKOFF_POLICY.iterator(), index, listener);
    }

    private void doStoreResult(final Iterator<TimeValue> backoff, final IndexRequestBuilder index, final ActionListener<Void> listener) {
        index.execute((ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (!(e instanceof SkyliteRejectedExecutionException) || !backoff.hasNext()) {
                    listener.onFailure(e);
                } else {
                    TimeValue wait = (TimeValue)backoff.next();
                    logger.warn(() -> new ParameterizedMessage("failed to store task result, retrying in [{}]", (Object)wait), (Throwable)e);
                    TaskResultsService.this.threadPool.schedule(() -> TaskResultsService.this.doStoreResult(backoff, index, (ActionListener<Void>)listener), wait, "same");
                }
            }
        });
    }
}

