/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry;

import io.skylite.common.annotation.ExperimentalApi;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.List;
import java.util.Map;

@ExperimentalApi
public class TelemetrySettings {
    public static final Setting<Boolean> TRACER_ENABLED_SETTING = Setting.boolSetting((String)"telemetry.tracer.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> TRACER_FEATURE_ENABLED_SETTING = Setting.boolSetting((String)"telemetry.feature.tracer.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
    public static final Setting<Boolean> METRICS_FEATURE_ENABLED_SETTING = Setting.boolSetting((String)"telemetry.feature.metrics.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
    public static final Setting<Double> TRACER_SAMPLER_PROBABILITY = Setting.doubleSetting((String)"telemetry.tracer.sampler.probability", (double)0.01, (double)0.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> METRICS_PUBLISH_INTERVAL_SETTING = Setting.timeSetting((String)"telemetry.otel.metrics.publish.interval", (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
    private volatile boolean tracingEnabled;
    private volatile double samplingProbability;
    private final boolean tracingFeatureEnabled;
    private final boolean metricsFeatureEnabled;

    public TelemetrySettings(Settings settings, ClusterSettings clusterSettings) {
        this.tracingEnabled = (Boolean)TRACER_ENABLED_SETTING.get(settings);
        this.samplingProbability = (Double)TRACER_SAMPLER_PROBABILITY.get(settings);
        this.tracingFeatureEnabled = (Boolean)TRACER_FEATURE_ENABLED_SETTING.get(settings);
        this.metricsFeatureEnabled = (Boolean)METRICS_FEATURE_ENABLED_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(TRACER_ENABLED_SETTING, this::setTracingEnabled);
        clusterSettings.addSettingsUpdateConsumer(TRACER_SAMPLER_PROBABILITY, this::setSamplingProbability);
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public void setSamplingProbability(double samplingProbability) {
        this.samplingProbability = samplingProbability;
    }

    public double getSamplingProbability() {
        return this.samplingProbability;
    }

    public boolean isTracingFeatureEnabled() {
        return this.tracingFeatureEnabled;
    }

    public boolean isMetricsFeatureEnabled() {
        return this.metricsFeatureEnabled;
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public Map<List<String>, List<Setting<?>>> getFeatureFlaggedSettings() {
            return Map.of(List.of("lucenia.experimental.feature.telemetry.enabled"), List.of(TRACER_ENABLED_SETTING, TRACER_SAMPLER_PROBABILITY, METRICS_PUBLISH_INTERVAL_SETTING, TRACER_FEATURE_ENABLED_SETTING, METRICS_FEATURE_ENABLED_SETTING));
        }
    }
}

