/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import io.skylite.common.annotation.InternalApi;
import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.TracerContextStorage;
import io.skylite.common.telemetry.tracing.TracingTelemetry;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.concurrent.ThreadContextStatePropagator;
import io.skylite.telemetry.tracing.SpanReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@InternalApi
public class ThreadContextBasedTracerContextStorage
implements TracerContextStorage<String, Span>,
ThreadContextStatePropagator {
    private final ThreadContext threadContext;
    private final TracingTelemetry tracingTelemetry;

    public ThreadContextBasedTracerContextStorage(ThreadContext threadContext, TracingTelemetry tracingTelemetry) {
        this.threadContext = Objects.requireNonNull(threadContext);
        this.tracingTelemetry = Objects.requireNonNull(tracingTelemetry);
        this.threadContext.registerThreadContextStatePropagator((ThreadContextStatePropagator)this);
    }

    public Span get(String key) {
        return this.getCurrentSpan(key);
    }

    public void put(String key, Span span) {
        SpanReference currentSpanRef = (SpanReference)this.threadContext.getTransient(key);
        if (currentSpanRef == null) {
            this.threadContext.putTransient(key, (Object)new SpanReference(span));
        } else {
            currentSpanRef.setSpan(span);
        }
    }

    public Map<String, Object> transients(Map<String, Object> source) {
        SpanReference current;
        HashMap<String, Object> transients = new HashMap<String, Object>();
        if (source.containsKey("current_span") && (current = (SpanReference)source.get("current_span")) != null) {
            transients.put("current_span", new SpanReference(current.getSpan()));
        }
        return transients;
    }

    public Map<String, String> headers(Map<String, Object> source) {
        SpanReference current;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (source.containsKey("current_span") && (current = (SpanReference)source.get("current_span")) != null && current.getSpan() != null) {
            this.tracingTelemetry.getContextPropagator().inject(current.getSpan(), (key, value) -> headers.put((String)key, (String)value));
        }
        return headers;
    }

    Span getCurrentSpan(String key) {
        SpanReference currentSpanRef = (SpanReference)this.threadContext.getTransient(key);
        return currentSpanRef == null ? null : currentSpanRef.getSpan();
    }
}

