/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.channels;

import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.SpanScope;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class TraceableRestChannel
implements RestChannel {
    private final RestChannel delegate;
    private final Span span;
    private final Tracer tracer;

    private TraceableRestChannel(RestChannel delegate, Span span, Tracer tracer) {
        this.span = Objects.requireNonNull(span);
        this.delegate = Objects.requireNonNull(delegate);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public static RestChannel create(RestChannel delegate, Span span, Tracer tracer) {
        if (tracer.isRecording()) {
            return new TraceableRestChannel(delegate, span, tracer);
        }
        return delegate;
    }

    public XContentBuilder newBuilder() throws IOException {
        return this.delegate.newBuilder();
    }

    public XContentBuilder newErrorBuilder() throws IOException {
        return this.delegate.newErrorBuilder();
    }

    public XContentBuilder newBuilder(MediaType mediaType, boolean useFiltering) throws IOException {
        return this.delegate.newBuilder(mediaType, useFiltering);
    }

    public XContentBuilder newBuilder(MediaType mediaType, MediaType responseContentType, boolean useFiltering) throws IOException {
        return this.delegate.newBuilder(mediaType, responseContentType, useFiltering);
    }

    public BytesStreamOutput bytesOutput() {
        return this.delegate.bytesOutput();
    }

    public RestRequest request() {
        return this.delegate.request();
    }

    public boolean detailedErrorsEnabled() {
        return this.delegate.detailedErrorsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(RestResponse response) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.sendResponse(response);
        }
        finally {
            this.span.endSpan();
        }
    }
}

