/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.util.NilReferencingObject;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.xml.bind.gml.Measure;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.datum.PrimeMeridian;

@XmlType(name="PrimeMeridianType")
@XmlRootElement(name="PrimeMeridian")
public class DefaultPrimeMeridian
extends AbstractIdentifiedObject
implements PrimeMeridian {
    private static final long serialVersionUID = 541978454643213305L;
    private double greenwichLongitude;
    private Unit<Angle> angularUnit;

    public DefaultPrimeMeridian(Map<String, ?> properties, double greenwichLongitude, Unit<Angle> angularUnit) {
        super(properties);
        ArgumentChecks.ensureFinite((String)"greenwichLongitude", (double)greenwichLongitude);
        ArgumentChecks.ensureNonNull((String)"angularUnit", angularUnit);
        this.greenwichLongitude = greenwichLongitude;
        this.angularUnit = angularUnit;
    }

    protected DefaultPrimeMeridian(PrimeMeridian meridian) {
        super((IdentifiedObject)meridian);
        this.greenwichLongitude = meridian.getGreenwichLongitude();
        this.angularUnit = meridian.getAngularUnit();
    }

    public static DefaultPrimeMeridian castOrCopy(PrimeMeridian object) {
        return object == null || object instanceof DefaultPrimeMeridian ? (DefaultPrimeMeridian)object : new DefaultPrimeMeridian(object);
    }

    public Class<? extends PrimeMeridian> getInterface() {
        return PrimeMeridian.class;
    }

    public double getGreenwichLongitude() {
        return this.greenwichLongitude;
    }

    public double getGreenwichLongitude(Unit<Angle> unit) {
        return this.getAngularUnit().getConverterTo(unit).convert(this.getGreenwichLongitude());
    }

    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            switch (mode) {
                case STRICT: {
                    DefaultPrimeMeridian that = (DefaultPrimeMeridian)object;
                    return Numerics.equals((double)this.greenwichLongitude, (double)that.greenwichLongitude) && Objects.equals(this.angularUnit, that.angularUnit);
                }
                case BY_CONTRACT: {
                    PrimeMeridian that = (PrimeMeridian)object;
                    return Numerics.equals((double)this.getGreenwichLongitude(), (double)that.getGreenwichLongitude()) && Objects.equals(this.getAngularUnit(), that.getAngularUnit());
                }
            }
            double v1 = this.getGreenwichLongitude((Unit<Angle>)Units.DEGREE);
            double v2 = ReferencingUtilities.getGreenwichLongitude((PrimeMeridian)object, (Unit<Angle>)Units.DEGREE);
            if (mode == ComparisonMode.IGNORE_METADATA) {
                return Numerics.equals((double)v1, (double)v2);
            }
            if (Numerics.epsilonEqual((double)v1, (double)v2, (double)8.999280057595393E-8)) {
                return true;
            }
            assert (mode != ComparisonMode.DEBUG) : Numerics.messageForDifference((String)"greenwichLongitude", (double)v1, (double)v2);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + Double.doubleToLongBits(this.greenwichLongitude) + (long)Objects.hashCode(this.angularUnit);
    }

    private static boolean isElementOfBaseCRS(Formatter formatter) {
        return formatter.getEnclosingElement(2) instanceof GeneralDerivedCRS;
    }

    private static boolean beConservative(Formatter formatter, Unit<Angle> contextualUnit) {
        return !contextualUnit.equals((Object)Units.DEGREE) && !DefaultPrimeMeridian.isElementOfBaseCRS(formatter);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Unit contextualUnit;
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        Object unit = contextualUnit = formatter.toContextualUnit(Units.DEGREE);
        if (!isWKT1) {
            unit = this.getAngularUnit();
            if (convention != Convention.INTERNAL) {
                unit = WKTUtilities.toFormattable(unit);
            }
        }
        formatter.append(this.getGreenwichLongitude((Unit<Angle>)unit));
        if (isWKT1) {
            return "PrimeM";
        }
        if (!convention.isSimplified() || !contextualUnit.equals(unit) || DefaultPrimeMeridian.beConservative(formatter, contextualUnit)) {
            formatter.append((Unit<?>)unit);
        }
        return formatter.shortOrLong("PrimeM", "PrimeMeridian");
    }

    private DefaultPrimeMeridian() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    @XmlElement(name="greenwichLongitude", required=true)
    private Measure getGreenwichMeasure() {
        return new Measure(this.greenwichLongitude, this.angularUnit);
    }

    private void setGreenwichMeasure(Measure measure) {
        if (this.greenwichLongitude == 0.0 && this.angularUnit == null) {
            this.greenwichLongitude = measure.value;
            this.angularUnit = measure.getUnit(Angle.class);
            if (this.angularUnit == null) {
                this.angularUnit = Units.DEGREE;
                if (this.greenwichLongitude != 0.0) {
                    Measure.missingUOM(DefaultPrimeMeridian.class, (String)"setGreenwichMeasure");
                }
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultPrimeMeridian.class, (String)"setGreenwichMeasure", (String)"greenwichLongitude");
        }
    }
}

