/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.metadata.internal.NameMeaning;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.MultiAuthoritiesFactory;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

final class AuthorityFactoryIdentifier {
    private static final Locale IDENTIFIER_LOCALE = Locale.US;
    static final byte CRS = 0;
    static final byte CS = 1;
    static final byte DATUM = 2;
    static final byte OPERATION = 3;
    static final byte GEODETIC = 4;
    static final byte ANY = 5;
    private static final Class<? extends AuthorityFactory>[] TYPES = new Class[6];
    final byte type;
    private String authority;
    private String version;

    private AuthorityFactoryIdentifier(byte type, String authority, String version) {
        this.type = type;
        this.authority = authority;
        this.version = version;
    }

    static AuthorityFactoryIdentifier create(Class<? extends AuthorityFactory> type, String authority, String version) {
        for (byte i = 0; i < TYPES.length; i = (byte)(i + 1)) {
            if (!TYPES[i].isAssignableFrom(type)) continue;
            return AuthorityFactoryIdentifier.create(i, authority, version);
        }
        throw new IllegalArgumentException();
    }

    static AuthorityFactoryIdentifier create(byte type, String authority, String version) {
        return new AuthorityFactoryIdentifier(type, authority.toUpperCase(IDENTIFIER_LOCALE), version == null ? null : version.toLowerCase(IDENTIFIER_LOCALE));
    }

    AuthorityFactoryIdentifier unversioned(String newAuthority) {
        if (this.version == null && newAuthority.equals(this.authority)) {
            return this;
        }
        return new AuthorityFactoryIdentifier(this.type, newAuthority.toUpperCase(IDENTIFIER_LOCALE), null);
    }

    AuthorityFactoryIdentifier versionOf(Citation factory) {
        String newVersion = NameMeaning.getVersion((Citation)factory);
        if (newVersion != null) {
            newVersion = newVersion.toLowerCase(IDENTIFIER_LOCALE);
        }
        if (Objects.equals(this.version, newVersion)) {
            return this;
        }
        return new AuthorityFactoryIdentifier(this.type, this.authority, newVersion);
    }

    AuthorityFactoryIdentifier newType(byte newType) {
        return new AuthorityFactoryIdentifier(newType, this.authority, this.version);
    }

    AuthorityFactoryIdentifier intern() {
        this.authority = this.authority.intern();
        if (this.version != null) {
            this.version = this.version.intern();
        }
        return this;
    }

    public int hashCode() {
        return this.type + 31 * this.authority.hashCode() + Objects.hashCode(this.version);
    }

    public boolean equals(Object other) {
        if (other instanceof AuthorityFactoryIdentifier) {
            AuthorityFactoryIdentifier that = (AuthorityFactoryIdentifier)other;
            if (this.type == that.type && this.authority.equals(that.authority)) {
                return Objects.equals(this.version, that.version);
            }
        }
        return false;
    }

    boolean isSameAuthority(AuthorityFactoryIdentifier other) {
        return this.authority.equals(other.authority);
    }

    CharSequence getAuthorityAndVersion() {
        String name = this.authority;
        if (this.hasVersion()) {
            name = Vocabulary.formatInternational((short)218, (Object[])new Object[]{name, this.version});
        }
        return name;
    }

    boolean hasVersion() {
        return this.version != null;
    }

    void logConflict(AuthorityFactory used) {
        this.log(Resources.forLocale(null).getLogRecord(Level.WARNING, (short)19, TYPES[this.type], this.getAuthorityAndVersion(), Classes.getClass((Object)used)));
    }

    void logFallback() {
        this.log(Resources.forLocale(null).getLogRecord(Level.WARNING, (short)17, this.authority, this.version));
    }

    private void log(LogRecord record) {
        Logging.completeAndLog((Logger)GeodeticAuthorityFactory.LOGGER, MultiAuthoritiesFactory.class, (String)"getAuthorityFactory", (LogRecord)record);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Classes.getShortName(TYPES[this.type])).append(':').append(this.authority);
        if (this.version != null) {
            buffer.append(':').append(this.version);
        }
        return buffer.toString();
    }

    static {
        AuthorityFactoryIdentifier.TYPES[0] = CRSAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[1] = CSAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[2] = DatumAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[3] = CoordinateOperationAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[4] = GeodeticAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[5] = AuthorityFactory.class;
    }
}

