/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.dissect;

import io.skylite.dissect.DissectKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class DissectMatch {
    private final String appendSeparator;
    private final Map<String, String> results;
    private final Map<String, String> simpleResults;
    private final Map<String, ReferenceResult> referenceResults;
    private final Map<String, AppendResult> appendResults;
    private int implicitAppendOrder = -1000;
    private final int maxMatches;
    private final int maxResults;
    private final int appendCount;
    private final int referenceCount;
    private final int simpleCount;
    private int matches = 0;

    DissectMatch(String appendSeparator, int maxMatches, int maxResults, int appendCount, int referenceCount) {
        if (maxMatches <= 0 || maxResults <= 0) {
            throw new IllegalArgumentException("Expected results are zero, can not construct DissectMatch");
        }
        this.maxMatches = maxMatches;
        this.maxResults = maxResults;
        this.appendCount = appendCount;
        this.referenceCount = referenceCount;
        this.appendSeparator = appendSeparator;
        this.results = new HashMap<String, String>(maxResults);
        this.simpleCount = maxMatches - referenceCount - appendCount;
        this.simpleResults = this.simpleCount <= 0 ? null : new HashMap(this.simpleCount);
        this.referenceResults = referenceCount <= 0 ? null : new HashMap(referenceCount);
        this.appendResults = appendCount <= 0 ? null : new HashMap(appendCount);
    }

    void add(DissectKey key, String value) {
        ++this.matches;
        if (key.skip()) {
            return;
        }
        switch (key.getModifier()) {
            case NONE: {
                this.simpleResults.put(key.getName(), value);
                break;
            }
            case APPEND: {
                this.appendResults.computeIfAbsent(key.getName(), k -> new AppendResult(this.appendSeparator)).addValue(value, this.implicitAppendOrder++);
                break;
            }
            case APPEND_WITH_ORDER: {
                this.appendResults.computeIfAbsent(key.getName(), k -> new AppendResult(this.appendSeparator)).addValue(value, key.getAppendPosition());
                break;
            }
            case FIELD_NAME: {
                this.referenceResults.computeIfAbsent(key.getName(), k -> new ReferenceResult(this)).setKey(value);
                break;
            }
            case FIELD_VALUE: {
                this.referenceResults.computeIfAbsent(key.getName(), k -> new ReferenceResult(this)).setValue(value);
            }
        }
    }

    boolean fullyMatched() {
        return this.matches == this.maxMatches;
    }

    boolean isValid(Map<String, String> results) {
        return this.fullyMatched() && results.size() == this.maxResults;
    }

    Map<String, String> getResults() {
        this.results.clear();
        if (this.simpleCount > 0) {
            this.results.putAll(this.simpleResults);
        }
        if (this.referenceCount > 0) {
            this.referenceResults.forEach((k, v) -> this.results.put(v.getKey(), v.getValue()));
        }
        if (this.appendCount > 0) {
            this.appendResults.forEach((k, v) -> this.results.put((String)k, v.getAppendResult()));
        }
        return this.results;
    }

    private final class AppendResult {
        private final List<AppendValue> values = new ArrayList<AppendValue>();
        private final String appendSeparator;

        private AppendResult(String appendSeparator) {
            this.appendSeparator = appendSeparator;
        }

        private void addValue(String value, int order) {
            this.values.add(new AppendValue(DissectMatch.this, value, order));
        }

        private String getAppendResult() {
            Collections.sort(this.values);
            return this.values.stream().map(AppendValue::getValue).collect(Collectors.joining(this.appendSeparator));
        }
    }

    private final class ReferenceResult {
        private String key;
        private String value;

        private ReferenceResult(DissectMatch dissectMatch) {
        }

        private String getKey() {
            return this.key;
        }

        private String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }

        private void setKey(String key) {
            this.key = key;
        }
    }

    private final class AppendValue
    implements Comparable<AppendValue> {
        private final String value;
        private final int order;

        private AppendValue(DissectMatch dissectMatch, String value, int order) {
            this.value = value;
            this.order = order;
        }

        private String getValue() {
            return this.value;
        }

        private int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(AppendValue o) {
            return Integer.compare(this.order, o.getOrder());
        }
    }
}

