/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.s3;

import io.lucenia.repositories.s3.AmazonAsyncS3Reference;
import io.lucenia.repositories.s3.AmazonAsyncS3WithCredentials;
import io.lucenia.repositories.s3.AmazonS3Reference;
import io.lucenia.repositories.s3.S3BlobStore;
import io.lucenia.repositories.s3.S3Repository;
import io.lucenia.repositories.s3.S3RetryingInputStream;
import io.lucenia.repositories.s3.SocketAccess;
import io.lucenia.repositories.s3.async.UploadRequest;
import io.lucenia.repositories.s3.utils.HttpRangeUtils;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.SetOnce;
import io.skylite.common.StreamContext;
import io.skylite.common.action.ActionListener;
import io.skylite.common.annotation.ExperimentalApi;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobMetadata;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.blobstore.DeleteResult;
import io.skylite.common.blobstore.InputStreamWithMetadata;
import io.skylite.common.collect.Tuple;
import io.skylite.common.io.InputStreamContainer;
import io.skylite.core.blobstore.AbstractBlobContainer;
import io.skylite.core.blobstore.AsyncMultiStreamBlobContainer;
import io.skylite.core.blobstore.BlobStoreException;
import io.skylite.core.blobstore.PlainBlobMetadata;
import io.skylite.core.blobstore.stream.read.ReadContext;
import io.skylite.core.blobstore.stream.write.WriteContext;
import io.skylite.core.blobstore.stream.write.WritePriority;
import io.skylite.core.common.Strings;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectAttributes;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.utils.CollectionUtils;

class S3BlobContainer
extends AbstractBlobContainer
implements AsyncMultiStreamBlobContainer {
    private static final Logger logger = LogManager.getLogger(S3BlobContainer.class);
    private final S3BlobStore blobStore;
    private final String keyPath;

    S3BlobContainer(BlobPath path, S3BlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString();
    }

    public boolean blobExists(String blobName) {
        boolean bl;
        block9: {
            AmazonS3Reference clientReference = this.blobStore.clientReference();
            try {
                SocketAccess.doPrivileged(() -> ((S3Client)clientReference.get()).headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.blobStore.bucket()).key(this.buildKey(blobName)).build()));
                bl = true;
                if (clientReference == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (clientReference != null) {
                        try {
                            clientReference.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchKeyException e) {
                    return false;
                }
                catch (Exception e) {
                    throw new BlobStoreException("Failed to check if blob [" + blobName + "] exists", (Throwable)e);
                }
            }
            clientReference.close();
        }
        return bl;
    }

    @ExperimentalApi
    public InputStreamWithMetadata readBlobWithMetadata(String blobName) throws IOException {
        S3RetryingInputStream s3RetryingInputStream = new S3RetryingInputStream(this.blobStore, this.buildKey(blobName));
        return new InputStreamWithMetadata((InputStream)s3RetryingInputStream, s3RetryingInputStream.getMetadata());
    }

    public InputStream readBlob(String blobName) throws IOException {
        return new S3RetryingInputStream(this.blobStore, this.buildKey(blobName));
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (length == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new S3RetryingInputStream(this.blobStore, this.buildKey(blobName), position, Math.addExact(position, length - 1L));
    }

    public long readBlobPreferredLength() {
        return new ByteSizeValue(32L, ByteSizeUnit.MB).getBytes();
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.writeBlobWithMetadata(blobName, inputStream, blobSize, failIfAlreadyExists, null);
    }

    @ExperimentalApi
    public void writeBlobWithMetadata(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists, @Nullable Map<String, String> metadata) throws IOException {
        assert (inputStream.markSupported()) : "No mark support on inputStream breaks the S3 SDK's ability to retry requests";
        SocketAccess.doPrivilegedIOException(() -> {
            if (blobSize <= this.getLargeBlobThresholdInBytes()) {
                this.executeSingleUpload(this.blobStore, this.buildKey(blobName), inputStream, blobSize, metadata);
            } else {
                this.executeMultipartUpload(this.blobStore, this.buildKey(blobName), inputStream, blobSize, metadata);
            }
            return null;
        });
    }

    public void asyncBlobUpload(WriteContext writeContext, ActionListener<Void> completionListener) throws IOException {
        UploadRequest uploadRequest = new UploadRequest(this.blobStore.bucket(), this.buildKey(writeContext.getFileName()), writeContext.getFileSize(), writeContext.getWritePriority(), (CheckedConsumer<Boolean, IOException>)writeContext.getUploadFinalizer(), writeContext.doRemoteDataIntegrityCheck(), writeContext.getExpectedChecksum(), this.blobStore.isUploadRetryEnabled(), writeContext.getMetadata());
        try {
            Long partSize = this.calculateOptimalPartSize(writeContext, completionListener, uploadRequest);
            if (partSize == null) {
                return;
            }
            StreamContext streamContext = SocketAccess.doPrivileged(() -> writeContext.getStreamProvider(partSize.longValue()));
            try (AmazonAsyncS3Reference amazonS3Reference = SocketAccess.doPrivileged(this.blobStore::asyncClientReference);){
                S3AsyncClient s3AsyncClient = writeContext.getWritePriority() == WritePriority.URGENT ? ((AmazonAsyncS3WithCredentials)amazonS3Reference.get()).urgentClient() : (writeContext.getWritePriority() == WritePriority.HIGH ? ((AmazonAsyncS3WithCredentials)amazonS3Reference.get()).priorityClient() : ((AmazonAsyncS3WithCredentials)amazonS3Reference.get()).client());
                CompletableFuture<Void> completableFuture = this.blobStore.getAsyncTransferManager().uploadObject(s3AsyncClient, uploadRequest, streamContext, this.blobStore.getStatsMetricPublisher());
                completableFuture.whenComplete((response, throwable) -> {
                    if (throwable == null) {
                        completionListener.onResponse(response);
                    } else {
                        Exception ex = throwable instanceof Error ? new Exception((Throwable)throwable) : (Exception)throwable;
                        completionListener.onFailure(ex);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("exception error from blob container for file {}", (Object)writeContext.getFileName());
            throw new IOException(e);
        }
    }

    private Long calculateOptimalPartSize(WriteContext writeContext, ActionListener<Void> completionListener, UploadRequest uploadRequest) throws IOException {
        if (uploadRequest.getContentLength() > ByteSizeUnit.GB.toBytes(10L) && this.blobStore.isRedirectLargeUploads()) {
            StreamContext streamContext = SocketAccess.doPrivileged(() -> writeContext.getStreamProvider(uploadRequest.getContentLength()));
            InputStreamContainer inputStream = streamContext.provideStream(0);
            try {
                this.executeMultipartUpload(this.blobStore, uploadRequest.getKey(), inputStream.getInputStream(), uploadRequest.getContentLength(), uploadRequest.getMetadata());
                completionListener.onResponse(null);
            }
            catch (Exception ex) {
                logger.error(() -> new ParameterizedMessage("Failed to upload large file {} of size {} ", (Object)uploadRequest.getKey(), (Object)uploadRequest.getContentLength()), (Throwable)ex);
                completionListener.onFailure(ex);
            }
            return null;
        }
        return this.blobStore.getAsyncTransferManager().calculateOptimalPartSize(writeContext.getFileSize(), writeContext.getWritePriority(), this.blobStore.isUploadRetryEnabled());
    }

    @ExperimentalApi
    public void readBlobAsync(String blobName, ActionListener<ReadContext> listener) {
        try (AmazonAsyncS3Reference amazonS3Reference = SocketAccess.doPrivileged(this.blobStore::asyncClientReference);){
            S3AsyncClient s3AsyncClient = ((AmazonAsyncS3WithCredentials)amazonS3Reference.get()).client();
            String bucketName = this.blobStore.bucket();
            String blobKey = this.buildKey(blobName);
            CompletableFuture<GetObjectAttributesResponse> blobMetadataFuture = this.getBlobMetadata(s3AsyncClient, bucketName, blobKey);
            blobMetadataFuture.whenComplete((blobMetadata, throwable) -> {
                if (throwable != null) {
                    Exception ex = throwable.getCause() instanceof Exception ? (Exception)throwable.getCause() : new Exception(throwable.getCause());
                    listener.onFailure(ex);
                    return;
                }
                try {
                    String blobChecksum;
                    ArrayList<ReadContext.StreamPartCreator> blobPartInputStreamFutures = new ArrayList<ReadContext.StreamPartCreator>();
                    long blobSize = blobMetadata.objectSize();
                    Integer numberOfParts = blobMetadata.objectParts() == null ? null : blobMetadata.objectParts().totalPartsCount();
                    String string = blobChecksum = blobMetadata.checksum() == null ? null : blobMetadata.checksum().checksumCRC32();
                    if (numberOfParts == null) {
                        blobPartInputStreamFutures.add(() -> this.getBlobPartInputStreamContainer(s3AsyncClient, bucketName, blobKey, null));
                    } else {
                        int partNumber = 1;
                        while (partNumber <= numberOfParts) {
                            int innerPartNumber = partNumber++;
                            blobPartInputStreamFutures.add(() -> this.getBlobPartInputStreamContainer(s3AsyncClient, bucketName, blobKey, innerPartNumber));
                        }
                    }
                    listener.onResponse((Object)new ReadContext.Builder(blobSize, blobPartInputStreamFutures).blobChecksum(blobChecksum).build());
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
        catch (Exception ex) {
            listener.onFailure((Exception)((Object)SdkException.create((String)"Error occurred while fetching blob parts from the repository", (Throwable)ex)));
        }
    }

    public boolean remoteIntegrityCheckSupported() {
        return true;
    }

    long getLargeBlobThresholdInBytes() {
        return this.blobStore.bufferSizeInBytes();
    }

    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    public DeleteResult delete() throws IOException {
        AtomicLong deletedBlobs = new AtomicLong();
        AtomicLong deletedBytes = new AtomicLong();
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            ListObjectsV2Iterable listObjectsIterable = SocketAccess.doPrivileged(() -> ((S3Client)clientReference.get()).listObjectsV2Paginator((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.blobStore.bucket()).prefix(this.keyPath).overrideConfiguration(o -> o.addMetricPublisher(this.blobStore.getStatsMetricPublisher().listObjectsMetricPublisher)).build()));
            Iterator listObjectsResponseIterator = listObjectsIterable.iterator();
            while (listObjectsResponseIterator.hasNext()) {
                ListObjectsV2Response listObjectsResponse = SocketAccess.doPrivileged(listObjectsResponseIterator::next);
                List<String> blobsToDelete = listObjectsResponse.contents().stream().map(s3Object -> {
                    deletedBlobs.incrementAndGet();
                    deletedBytes.addAndGet(s3Object.size());
                    return s3Object.key();
                }).collect(Collectors.toList());
                if (!listObjectsResponseIterator.hasNext()) {
                    blobsToDelete.add(this.keyPath);
                }
                this.doDeleteBlobs(blobsToDelete, false);
            }
        }
        catch (SdkException e) {
            throw new IOException("Exception when deleting blob container [" + this.keyPath + "]", e);
        }
        return new DeleteResult(deletedBlobs.get(), deletedBytes.get());
    }

    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        this.doDeleteBlobs(blobNames, true);
    }

    private void doDeleteBlobs(List<String> blobNames, boolean relative) throws IOException {
        if (blobNames.isEmpty()) {
            return;
        }
        Set<String> outstanding = relative ? blobNames.stream().map(this::buildKey).collect(Collectors.toSet()) : new HashSet<String>(blobNames);
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            ArrayList<DeleteObjectsRequest> deleteRequests = new ArrayList<DeleteObjectsRequest>();
            ArrayList<String> partition = new ArrayList<String>();
            for (String key : outstanding) {
                partition.add(key);
                if (partition.size() != this.blobStore.getBulkDeletesSize()) continue;
                deleteRequests.add(this.bulkDelete(this.blobStore.bucket(), partition));
                partition.clear();
            }
            if (!partition.isEmpty()) {
                deleteRequests.add(this.bulkDelete(this.blobStore.bucket(), partition));
            }
            SocketAccess.doPrivilegedVoid(() -> {
                SdkException aex = null;
                for (DeleteObjectsRequest deleteRequest : deleteRequests) {
                    List keysInRequest = deleteRequest.delete().objects().stream().map(ObjectIdentifier::key).collect(Collectors.toList());
                    try {
                        DeleteObjectsResponse deleteObjectsResponse = ((S3Client)clientReference.get()).deleteObjects(deleteRequest);
                        outstanding.removeAll(keysInRequest);
                        outstanding.addAll(deleteObjectsResponse.errors().stream().map(S3Error::key).collect(Collectors.toSet()));
                        if (deleteObjectsResponse.errors().isEmpty()) continue;
                        logger.warn(() -> new ParameterizedMessage("Failed to delete some blobs {}", deleteObjectsResponse.errors().stream().map(s3Error -> "[" + s3Error.key() + "][" + s3Error.code() + "][" + s3Error.message() + "]").collect(Collectors.toList())));
                    }
                    catch (SdkException e) {
                        aex = (SdkException)ExceptionsHelper.useOrSuppress(aex, (Throwable)e);
                    }
                }
                if (aex != null) {
                    throw aex;
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Failed to delete blobs [" + String.valueOf(outstanding) + "]", e);
        }
        assert (outstanding.isEmpty());
    }

    private DeleteObjectsRequest bulkDelete(String bucket, List<String> blobs) {
        return (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete((Delete)Delete.builder().objects((Collection)blobs.stream().map(blob -> (ObjectIdentifier)ObjectIdentifier.builder().key(blob).build()).collect(Collectors.toList())).quiet(Boolean.valueOf(true)).build()).overrideConfiguration(o -> o.addMetricPublisher(this.blobStore.getStatsMetricPublisher().deleteObjectsMetricPublisher)).build();
    }

    public List<BlobMetadata> listBlobsByPrefixInSortedOrder(String blobNamePrefix, int limit, BlobContainer.BlobNameSortOrder blobNameSortOrder) throws IOException {
        List<BlobMetadata> list;
        block10: {
            if (blobNameSortOrder != BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC) {
                return super.listBlobsByPrefixInSortedOrder(blobNamePrefix, limit, blobNameSortOrder);
            }
            if (limit < 0) {
                throw new IllegalArgumentException("limit should not be a negative value");
            }
            String prefix = blobNamePrefix == null ? this.keyPath : this.buildKey(blobNamePrefix);
            AmazonS3Reference clientReference = this.blobStore.clientReference();
            try {
                List blobs = S3BlobContainer.executeListing(clientReference, this.listObjectsRequest(prefix, limit), limit).stream().flatMap(listing -> listing.contents().stream()).map(s3Object -> new PlainBlobMetadata(s3Object.key().substring(this.keyPath.length()), s3Object.size().longValue())).collect(Collectors.toList());
                list = blobs.subList(0, Math.min(limit, blobs.size()));
                if (clientReference == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (clientReference != null) {
                        try {
                            clientReference.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Exception when listing blobs by prefix [" + prefix + "]", e);
                }
            }
            clientReference.close();
        }
        return list;
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(@Nullable String blobNamePrefix) throws IOException {
        Map<String, BlobMetadata> map;
        block8: {
            String prefix = blobNamePrefix == null ? this.keyPath : this.buildKey(blobNamePrefix);
            AmazonS3Reference clientReference = this.blobStore.clientReference();
            try {
                map = S3BlobContainer.executeListing(clientReference, this.listObjectsRequest(prefix)).stream().flatMap(listing -> listing.contents().stream()).map(s3Object -> new PlainBlobMetadata(s3Object.key().substring(this.keyPath.length()), s3Object.size().longValue())).collect(Collectors.toMap(PlainBlobMetadata::name, Function.identity()));
                if (clientReference == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (clientReference != null) {
                        try {
                            clientReference.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SdkException e) {
                    throw new IOException("Exception when listing blobs by prefix [" + prefix + "]", e);
                }
            }
            clientReference.close();
        }
        return map;
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    public Map<String, BlobContainer> children() throws IOException {
        Map<String, BlobContainer> map;
        block8: {
            AmazonS3Reference clientReference = this.blobStore.clientReference();
            try {
                map = S3BlobContainer.executeListing(clientReference, this.listObjectsRequest(this.keyPath)).stream().flatMap(listObjectsResponse -> {
                    assert (listObjectsResponse.contents().stream().noneMatch(s -> {
                        for (CommonPrefix commonPrefix : listObjectsResponse.commonPrefixes()) {
                            if (!s.key().substring(this.keyPath.length()).startsWith(commonPrefix.prefix())) continue;
                            return true;
                        }
                        return false;
                    })) : "Response contained children for listed common prefixes.";
                    return listObjectsResponse.commonPrefixes().stream();
                }).map(commonPrefix -> commonPrefix.prefix().substring(this.keyPath.length())).filter(name -> !name.isEmpty()).map(name -> name.substring(0, name.length() - 1)).collect(Collectors.toMap(Function.identity(), name -> this.blobStore.blobContainer(this.path().add(name))));
                if (clientReference == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (clientReference != null) {
                        try {
                            clientReference.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SdkException e) {
                    throw new IOException("Exception when listing children of [" + this.path().buildAsString() + "]", e);
                }
            }
            clientReference.close();
        }
        return map;
    }

    private static List<ListObjectsV2Response> executeListing(AmazonS3Reference clientReference, ListObjectsV2Request listObjectsRequest) {
        return S3BlobContainer.executeListing(clientReference, listObjectsRequest, -1);
    }

    private static List<ListObjectsV2Response> executeListing(AmazonS3Reference clientReference, ListObjectsV2Request listObjectsRequest, int limit) {
        return SocketAccess.doPrivileged(() -> {
            ArrayList<ListObjectsV2Response> results = new ArrayList<ListObjectsV2Response>();
            int totalObjects = 0;
            ListObjectsV2Iterable listObjectsIterable = ((S3Client)clientReference.get()).listObjectsV2Paginator(listObjectsRequest);
            for (ListObjectsV2Response listObjectsV2Response : listObjectsIterable) {
                results.add(listObjectsV2Response);
                if (limit == -1 || (totalObjects += listObjectsV2Response.contents().size()) <= limit) continue;
                break;
            }
            return results;
        });
    }

    private ListObjectsV2Request listObjectsRequest(String keyPath) {
        return (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.blobStore.bucket()).prefix(keyPath).delimiter("/").overrideConfiguration(o -> o.addMetricPublisher(this.blobStore.getStatsMetricPublisher().listObjectsMetricPublisher)).build();
    }

    private ListObjectsV2Request listObjectsRequest(String keyPath, int limit) {
        return (ListObjectsV2Request)this.listObjectsRequest(keyPath).toBuilder().maxKeys(Integer.valueOf(Math.min(limit, 1000))).build();
    }

    private String buildKey(String blobName) {
        return this.keyPath + blobName;
    }

    void executeSingleUpload(S3BlobStore blobStore, String blobName, InputStream input, long blobSize) throws IOException {
        this.executeSingleUpload(blobStore, blobName, input, blobSize, null);
    }

    void executeSingleUpload(S3BlobStore blobStore, String blobName, InputStream input, long blobSize, Map<String, String> metadata) throws IOException {
        if (blobSize > S3Repository.MAX_FILE_SIZE.getBytes()) {
            throw new IllegalArgumentException("Upload request size [" + blobSize + "] can't be larger than " + String.valueOf(S3Repository.MAX_FILE_SIZE));
        }
        if (blobSize > blobStore.bufferSizeInBytes()) {
            throw new IllegalArgumentException("Upload request size [" + blobSize + "] can't be larger than buffer size");
        }
        PutObjectRequest.Builder putObjectRequestBuilder = PutObjectRequest.builder().bucket(blobStore.bucket()).key(blobName).contentLength(Long.valueOf(blobSize)).storageClass(blobStore.getStorageClass()).acl(blobStore.getCannedACL()).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().putObjectMetricPublisher));
        if (CollectionUtils.isNotEmpty(metadata)) {
            putObjectRequestBuilder = putObjectRequestBuilder.metadata(metadata);
        }
        if (blobStore.serverSideEncryption()) {
            putObjectRequestBuilder.serverSideEncryption(ServerSideEncryption.AES256);
        }
        PutObjectRequest putObjectRequest = (PutObjectRequest)putObjectRequestBuilder.build();
        try (AmazonS3Reference clientReference = blobStore.clientReference();){
            InputStream requestInputStream = blobStore.isUploadRetryEnabled() ? new BufferedInputStream(input, (int)(blobSize + 1L)) : input;
            SocketAccess.doPrivilegedVoid(() -> ((S3Client)clientReference.get()).putObject(putObjectRequest, RequestBody.fromInputStream((InputStream)requestInputStream, (long)blobSize)));
        }
        catch (SdkException e) {
            throw new IOException("Unable to upload object [" + blobName + "] using a single upload", e);
        }
    }

    void executeMultipartUpload(S3BlobStore blobStore, String blobName, InputStream input, long blobSize) throws IOException {
        this.executeMultipartUpload(blobStore, blobName, input, blobSize, null);
    }

    void executeMultipartUpload(S3BlobStore blobStore, String blobName, InputStream input, long blobSize, Map<String, String> metadata) throws IOException {
        this.ensureMultiPartUploadSize(blobSize);
        long partSize = blobStore.bufferSizeInBytes();
        Tuple<Long, Long> multiparts = S3BlobContainer.numberOfMultiparts(blobSize, partSize);
        if ((Long)multiparts.v1() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many multipart upload requests, maybe try a larger buffer size?");
        }
        int nbParts = ((Long)multiparts.v1()).intValue();
        long lastPartSize = (Long)multiparts.v2();
        assert (blobSize == (long)(nbParts - 1) * partSize + lastPartSize) : "blobSize does not match multipart sizes";
        SetOnce uploadId = new SetOnce();
        String bucketName = blobStore.bucket();
        boolean success = false;
        CreateMultipartUploadRequest.Builder createMultipartUploadRequestBuilder = CreateMultipartUploadRequest.builder().bucket(bucketName).key(blobName).storageClass(blobStore.getStorageClass()).acl(blobStore.getCannedACL()).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().multipartUploadMetricCollector));
        if (CollectionUtils.isNotEmpty(metadata)) {
            createMultipartUploadRequestBuilder.metadata(metadata);
        }
        if (blobStore.serverSideEncryption()) {
            createMultipartUploadRequestBuilder.serverSideEncryption(ServerSideEncryption.AES256);
        }
        InputStream requestInputStream = blobStore.isUploadRetryEnabled() ? new BufferedInputStream(input, (int)(partSize + 1L)) : input;
        CreateMultipartUploadRequest createMultipartUploadRequest = (CreateMultipartUploadRequest)createMultipartUploadRequestBuilder.build();
        try (AmazonS3Reference clientReference = blobStore.clientReference();){
            uploadId.set((Object)SocketAccess.doPrivileged(() -> ((S3Client)clientReference.get()).createMultipartUpload(createMultipartUploadRequest).uploadId()));
            if (Strings.isEmpty((CharSequence)((CharSequence)uploadId.get()))) {
                throw new IOException("Failed to initialize multipart upload " + blobName);
            }
            ArrayList<CompletedPart> parts = new ArrayList<CompletedPart>();
            long bytesCount = 0L;
            for (int i = 1; i <= nbParts; ++i) {
                UploadPartRequest uploadPartRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(bucketName).key(blobName).uploadId((String)uploadId.get()).partNumber(Integer.valueOf(i)).contentLength(Long.valueOf(i < nbParts ? partSize : lastPartSize)).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().multipartUploadMetricCollector)).build();
                bytesCount += uploadPartRequest.contentLength().longValue();
                UploadPartResponse uploadResponse = SocketAccess.doPrivileged(() -> ((S3Client)clientReference.get()).uploadPart(uploadPartRequest, RequestBody.fromInputStream((InputStream)requestInputStream, (long)uploadPartRequest.contentLength())));
                parts.add((CompletedPart)CompletedPart.builder().partNumber(uploadPartRequest.partNumber()).eTag(uploadResponse.eTag()).build());
            }
            if (bytesCount != blobSize) {
                throw new IOException("Failed to execute multipart upload for [" + blobName + "], expected " + blobSize + "bytes sent but got " + bytesCount);
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(bucketName).key(blobName).uploadId((String)uploadId.get()).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(parts).build()).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().multipartUploadMetricCollector)).build();
            SocketAccess.doPrivilegedVoid(() -> ((S3Client)clientReference.get()).completeMultipartUpload(completeMultipartUploadRequest));
            success = true;
        }
        catch (SdkException e) {
            throw new IOException("Unable to upload object [" + blobName + "] using multipart upload", e);
        }
        finally {
            if (!success && Strings.hasLength((String)((String)uploadId.get()))) {
                AbortMultipartUploadRequest abortRequest = (AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(bucketName).key(blobName).uploadId((String)uploadId.get()).build();
                try (AmazonS3Reference clientReference2 = blobStore.clientReference();){
                    SocketAccess.doPrivilegedVoid(() -> ((S3Client)clientReference2.get()).abortMultipartUpload(abortRequest));
                }
            }
        }
    }

    void ensureMultiPartUploadSize(long blobSize) {
        if (blobSize > S3Repository.MAX_FILE_SIZE_USING_MULTIPART.getBytes()) {
            throw new IllegalArgumentException("Multipart upload request size [" + blobSize + "] can't be larger than " + String.valueOf(S3Repository.MAX_FILE_SIZE_USING_MULTIPART));
        }
        if (blobSize < S3Repository.MIN_PART_SIZE_USING_MULTIPART.getBytes()) {
            throw new IllegalArgumentException("Multipart upload request size [" + blobSize + "] can't be smaller than " + String.valueOf(S3Repository.MIN_PART_SIZE_USING_MULTIPART));
        }
    }

    static Tuple<Long, Long> numberOfMultiparts(long totalSize, long partSize) {
        if (partSize <= 0L) {
            throw new IllegalArgumentException("Part size must be greater than zero");
        }
        if (totalSize == 0L || totalSize <= partSize) {
            return Tuple.tuple((Object)1L, (Object)totalSize);
        }
        long parts = totalSize / partSize;
        long remaining = totalSize % partSize;
        if (remaining == 0L) {
            return Tuple.tuple((Object)parts, (Object)partSize);
        }
        return Tuple.tuple((Object)(parts + 1L), (Object)remaining);
    }

    CompletableFuture<InputStreamContainer> getBlobPartInputStreamContainer(S3AsyncClient s3AsyncClient, String bucketName, String blobKey, @Nullable Integer partNumber) {
        boolean isMultipartObject = partNumber != null;
        GetObjectRequest.Builder getObjectRequestBuilder = GetObjectRequest.builder().bucket(bucketName).key(blobKey);
        if (isMultipartObject) {
            getObjectRequestBuilder.partNumber(partNumber);
        }
        return SocketAccess.doPrivileged(() -> s3AsyncClient.getObject((GetObjectRequest)getObjectRequestBuilder.build(), AsyncResponseTransformer.toBlockingInputStream()).thenApply(response -> S3BlobContainer.transformResponseToInputStreamContainer((ResponseInputStream<GetObjectResponse>)response, isMultipartObject)));
    }

    static InputStreamContainer transformResponseToInputStreamContainer(ResponseInputStream<GetObjectResponse> streamResponse, boolean isMultipartObject) {
        GetObjectResponse getObjectResponse = (GetObjectResponse)streamResponse.response();
        String contentRange = getObjectResponse.contentRange();
        Long contentLength = getObjectResponse.contentLength();
        if (isMultipartObject && contentRange == null || contentLength == null) {
            throw SdkException.builder().message("Failed to fetch required metadata for blob part").build();
        }
        long offset = isMultipartObject ? HttpRangeUtils.getStartOffsetFromRangeHeader(getObjectResponse.contentRange()) : 0L;
        return new InputStreamContainer(streamResponse, getObjectResponse.contentLength().longValue(), offset);
    }

    CompletableFuture<GetObjectAttributesResponse> getBlobMetadata(S3AsyncClient s3AsyncClient, String bucketName, String blobName) {
        GetObjectAttributesRequest getObjectAttributesRequest = (GetObjectAttributesRequest)GetObjectAttributesRequest.builder().bucket(bucketName).key(blobName).objectAttributes(new ObjectAttributes[]{ObjectAttributes.CHECKSUM, ObjectAttributes.OBJECT_SIZE, ObjectAttributes.OBJECT_PARTS}).build();
        return SocketAccess.doPrivileged(() -> s3AsyncClient.getObjectAttributes(getObjectAttributesRequest));
    }
}

