/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.s3;

import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.ReloadablePlugin;
import io.lucenia.plugins.RepositoryPlugin;
import io.lucenia.repositories.s3.S3AsyncService;
import io.lucenia.repositories.s3.S3ClientSettings;
import io.lucenia.repositories.s3.S3Repository;
import io.lucenia.repositories.s3.S3Service;
import io.lucenia.repositories.s3.async.AsyncExecutorContainer;
import io.lucenia.repositories.s3.async.AsyncTransferEventLoopGroup;
import io.lucenia.repositories.s3.async.AsyncTransferManager;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.RepositoryMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ExecutorBuilder;
import io.skylite.core.threadpool.FixedExecutorBuilder;
import io.skylite.core.threadpool.ScalingExecutorBuilder;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.opensearch.watcher.ResourceWatcherService;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    private static final String URGENT_FUTURE_COMPLETION = "urgent_future_completion";
    private static final String URGENT_STREAM_READER = "urgent_stream_reader";
    private static final String PRIORITY_FUTURE_COMPLETION = "priority_future_completion";
    private static final String PRIORITY_STREAM_READER = "priority_stream_reader";
    private static final String FUTURE_COMPLETION = "future_completion";
    private static final String STREAM_READER = "stream_reader";
    protected final S3Service service;
    private final S3AsyncService s3AsyncService;
    private final Path configPath;
    private AsyncExecutorContainer urgentExecutorBuilder;
    private AsyncExecutorContainer priorityExecutorBuilder;
    private AsyncExecutorContainer normalExecutorBuilder;

    public S3RepositoryPlugin(Settings settings, Path configPath) {
        this(settings, configPath, new S3Service(configPath), new S3AsyncService(configPath));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        ArrayList executorBuilders = new ArrayList();
        int halfProcMaxAt5 = S3RepositoryPlugin.halfAllocatedProcessorsMaxFive(S3RepositoryPlugin.allocatedProcessors(settings));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, URGENT_FUTURE_COMPLETION, S3RepositoryPlugin.urgentPoolCount(settings), 10000, URGENT_FUTURE_COMPLETION));
        executorBuilders.add((ExecutorBuilder<?>)new ScalingExecutorBuilder(URGENT_STREAM_READER, 1, halfProcMaxAt5, TimeValue.timeValueMinutes((long)5L)));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, PRIORITY_FUTURE_COMPLETION, S3RepositoryPlugin.priorityPoolCount(settings), 10000, PRIORITY_FUTURE_COMPLETION));
        executorBuilders.add((ExecutorBuilder<?>)new ScalingExecutorBuilder(PRIORITY_STREAM_READER, 1, halfProcMaxAt5, TimeValue.timeValueMinutes((long)5L)));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, FUTURE_COMPLETION, S3RepositoryPlugin.normalPoolCount(settings), 10000, FUTURE_COMPLETION));
        executorBuilders.add((ExecutorBuilder<?>)new ScalingExecutorBuilder(STREAM_READER, 1, halfProcMaxAt5, TimeValue.timeValueMinutes((long)5L)));
        return executorBuilders;
    }

    static int halfAllocatedProcessorsMaxFive(int allocatedProcessors) {
        return S3RepositoryPlugin.boundedBy((allocatedProcessors + 1) / 2, 1, 5);
    }

    S3RepositoryPlugin(Settings settings, Path configPath, S3Service service, S3AsyncService s3AsyncService) {
        this.service = Objects.requireNonNull(service, "S3 service must not be null");
        this.configPath = configPath;
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings, configPath);
        this.s3AsyncService = Objects.requireNonNull(s3AsyncService, "S3AsyncService must not be null");
        this.service.refreshAndClearCache(clientsSettings);
        this.s3AsyncService.refreshAndClearCache(clientsSettings);
    }

    private static int boundedBy(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    private static int allocatedProcessors(Settings settings) {
        return SkyliteExecutors.allocatedProcessors((Settings)settings);
    }

    private static int urgentPoolCount(Settings settings) {
        return S3RepositoryPlugin.boundedBy((S3RepositoryPlugin.allocatedProcessors(settings) + 7) / 8, 1, 2);
    }

    private static int priorityPoolCount(Settings settings) {
        return S3RepositoryPlugin.boundedBy((S3RepositoryPlugin.allocatedProcessors(settings) + 1) / 2, 2, 4);
    }

    private static int normalPoolCount(Settings settings) {
        return S3RepositoryPlugin.boundedBy((S3RepositoryPlugin.allocatedProcessors(settings) + 7) / 8, 1, 2);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        int urgentEventLoopThreads = S3RepositoryPlugin.urgentPoolCount(clusterService.getSettings());
        int priorityEventLoopThreads = S3RepositoryPlugin.priorityPoolCount(clusterService.getSettings());
        int normalEventLoopThreads = S3RepositoryPlugin.normalPoolCount(clusterService.getSettings());
        this.urgentExecutorBuilder = new AsyncExecutorContainer(threadPool.executor(URGENT_FUTURE_COMPLETION), threadPool.executor(URGENT_STREAM_READER), new AsyncTransferEventLoopGroup(urgentEventLoopThreads));
        this.priorityExecutorBuilder = new AsyncExecutorContainer(threadPool.executor(PRIORITY_FUTURE_COMPLETION), threadPool.executor(PRIORITY_STREAM_READER), new AsyncTransferEventLoopGroup(priorityEventLoopThreads));
        this.normalExecutorBuilder = new AsyncExecutorContainer(threadPool.executor(FUTURE_COMPLETION), threadPool.executor(STREAM_READER), new AsyncTransferEventLoopGroup(normalEventLoopThreads));
        return Collections.emptyList();
    }

    protected S3Repository createRepository(RepositoryMetadata metadata, NamedXContentRegistry registry, ClusterService clusterService, RecoverySettings recoverySettings) {
        AsyncTransferManager asyncUploadUtils = new AsyncTransferManager(((ByteSizeValue)S3Repository.PARALLEL_MULTIPART_UPLOAD_MINIMUM_PART_SIZE_SETTING.get(clusterService.getSettings())).getBytes(), this.normalExecutorBuilder.getStreamReader(), this.priorityExecutorBuilder.getStreamReader(), this.urgentExecutorBuilder.getStreamReader());
        return new S3Repository(metadata, registry, this.service, clusterService, recoverySettings, asyncUploadUtils, this.urgentExecutorBuilder, this.priorityExecutorBuilder, this.normalExecutorBuilder, this.s3AsyncService, (Boolean)S3Repository.PARALLEL_MULTIPART_UPLOAD_ENABLED_SETTING.get(clusterService.getSettings()), this.configPath);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry registry, ClusterService clusterService, RecoverySettings recoverySettings) {
        return Collections.singletonMap("s3", metadata -> this.createRepository(metadata, registry, clusterService, recoverySettings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(S3ClientSettings.ACCESS_KEY_SETTING, S3ClientSettings.SECRET_KEY_SETTING, S3ClientSettings.SESSION_TOKEN_SETTING, S3ClientSettings.ENDPOINT_SETTING, S3ClientSettings.PROTOCOL_SETTING, S3ClientSettings.PROXY_TYPE_SETTING, S3ClientSettings.PROXY_HOST_SETTING, S3ClientSettings.PROXY_PORT_SETTING, S3ClientSettings.PROXY_USERNAME_SETTING, S3ClientSettings.PROXY_PASSWORD_SETTING, S3ClientSettings.READ_TIMEOUT_SETTING, S3ClientSettings.MAX_RETRIES_SETTING, S3ClientSettings.USE_THROTTLE_RETRIES_SETTING, S3ClientSettings.USE_PATH_STYLE_ACCESS, S3Repository.ACCESS_KEY_SETTING, S3Repository.SECRET_KEY_SETTING, S3ClientSettings.SIGNER_OVERRIDE, S3ClientSettings.REGION, S3ClientSettings.ROLE_ARN_SETTING, S3ClientSettings.IDENTITY_TOKEN_FILE_SETTING, S3ClientSettings.ROLE_SESSION_NAME_SETTING, S3Repository.PARALLEL_MULTIPART_UPLOAD_MINIMUM_PART_SIZE_SETTING, S3Repository.PARALLEL_MULTIPART_UPLOAD_ENABLED_SETTING, S3Repository.REDIRECT_LARGE_S3_UPLOAD, S3Repository.UPLOAD_RETRY_ENABLED);
    }

    public void reload(Settings settings) {
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings, this.configPath);
        this.service.refreshAndClearCache(clientsSettings);
        this.s3AsyncService.refreshAndClearCache(clientsSettings);
    }

    public void close() throws IOException {
        this.service.close();
        this.s3AsyncService.close();
    }
}

