/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.s3.async;

import io.lucenia.repositories.s3.async.AsyncTransferEventLoopGroup;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncExecutorContainer
implements Closeable {
    private static final Logger logger = LogManager.getLogger(AsyncExecutorContainer.class);
    private final ExecutorService futureCompletionExecutor;
    private final ExecutorService streamReader;
    private final AsyncTransferEventLoopGroup asyncTransferEventLoopGroup;

    public AsyncExecutorContainer(ExecutorService futureCompletionExecutor, ExecutorService streamReader, AsyncTransferEventLoopGroup asyncTransferEventLoopGroup) {
        this.asyncTransferEventLoopGroup = asyncTransferEventLoopGroup;
        this.streamReader = streamReader;
        this.futureCompletionExecutor = futureCompletionExecutor;
    }

    public ExecutorService getFutureCompletionExecutor() {
        return this.futureCompletionExecutor;
    }

    public AsyncTransferEventLoopGroup getAsyncTransferEventLoopGroup() {
        return this.asyncTransferEventLoopGroup;
    }

    public ExecutorService getStreamReader() {
        return this.streamReader;
    }

    @Override
    public void close() throws IOException {
        this.shutdownExecutorService(this.streamReader, "streamReader");
        this.shutdownExecutorService(this.futureCompletionExecutor, "futureCompletionExecutor");
        if (this.asyncTransferEventLoopGroup != null) {
            this.asyncTransferEventLoopGroup.close();
        }
    }

    private void shutdownExecutorService(ExecutorService executor, String name) {
        if (executor != null) {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    logger.warn("Executor {} did not terminate within 5 seconds, forcing shutdown", (Object)name);
                    executor.shutdownNow();
                    if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        logger.warn("Executor {} could not be terminated", (Object)name);
                    }
                }
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for executor {} to terminate", (Object)name);
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

