/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.s3.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.core.exception.SdkException;

public final class HttpRangeUtils {
    private static final Pattern RANGE_PATTERN = Pattern.compile("^bytes\\s+(\\d+)-\\d+[/\\d*]+$");

    public static Long getStartOffsetFromRangeHeader(String headerValue) {
        Matcher matcher = RANGE_PATTERN.matcher(headerValue);
        if (!matcher.find()) {
            throw SdkException.create((String)("Regex match for Content-Range header {" + headerValue + "} failed"), (Throwable)new RuntimeException());
        }
        return Long.parseLong(matcher.group(1));
    }

    public static String toHttpRangeHeader(long start, long end) {
        return "bytes=" + start + "-" + end;
    }
}

