/*
 * Decompiled with CFR 0.152.
 */
package io.skylite;

import io.skylite.Build;
import io.skylite.LegacyESVersion;
import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.annotation.PublicApi;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.Strings;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

@PublicApi(since="1.0.0")
public final class LuceniaVersion
extends Version<LuceniaVersion> {
    public static final LuceniaVersion V_0_1_0 = new LuceniaVersion(10099, org.apache.lucene.util.Version.LUCENE_9_11_0);
    public static final LuceniaVersion V_0_1_1 = new LuceniaVersion(10199, org.apache.lucene.util.Version.LUCENE_9_11_0);
    public static final LuceniaVersion V_0_2_0 = new LuceniaVersion(20099, org.apache.lucene.util.Version.LUCENE_10_0_0);
    public static final LuceniaVersion V_0_2_1 = new LuceniaVersion(20199, org.apache.lucene.util.Version.LUCENE_10_0_0);
    public static final LuceniaVersion V_0_3_0 = new LuceniaVersion(30099, org.apache.lucene.util.Version.LUCENE_10_0_0);
    public static final LuceniaVersion V_0_3_1 = new LuceniaVersion(30199, org.apache.lucene.util.Version.LUCENE_10_0_0);
    public static final LuceniaVersion V_0_4_0 = new LuceniaVersion(40099, org.apache.lucene.util.Version.LUCENE_10_1_0);
    public static final LuceniaVersion V_0_4_1 = new LuceniaVersion(40199, org.apache.lucene.util.Version.LUCENE_10_1_0);
    public static final LuceniaVersion V_0_5_0 = new LuceniaVersion(50099, org.apache.lucene.util.Version.LUCENE_10_2_1);
    public static final LuceniaVersion V_0_5_1 = new LuceniaVersion(50199, org.apache.lucene.util.Version.LUCENE_10_2_1);
    public static final LuceniaVersion V_0_6_0 = new LuceniaVersion(60099, org.apache.lucene.util.Version.LUCENE_10_2_1);
    public static final LuceniaVersion V_0_6_1 = new LuceniaVersion(60199, org.apache.lucene.util.Version.LUCENE_10_2_1);
    public static final LuceniaVersion V_0_7_0 = new LuceniaVersion(70099, org.apache.lucene.util.Version.LUCENE_10_2_1);
    public static final LuceniaVersion V_0_7_1 = new LuceniaVersion(70199, org.apache.lucene.util.Version.LUCENE_10_2_1);
    public static final LuceniaVersion V_0_8_0 = new LuceniaVersion(80099, org.apache.lucene.util.Version.LUCENE_10_3_1);
    public static final LuceniaVersion V_0_8_1;
    public static final LuceniaVersion CURRENT;
    protected static final Map<Integer, LuceniaVersion> idToVersion;
    protected static final Map<String, LuceniaVersion> stringToVersion;
    public static final List<LuceniaVersion> declaredVersions;
    public static final int MASK = 0x10000000;

    private static int mask(int id) {
        return id ^ 0x10000000;
    }

    public static int unmask(int id) {
        if (id != 0) {
            return (id ^ 0x10000000) & 0xEFFFFFFF;
        }
        return id;
    }

    @Override
    protected Function<Integer, Integer> unmask() {
        return LuceniaVersion::unmask;
    }

    public static LuceniaVersion fromId(int id) {
        LuceniaVersion known = idToVersion.get(id = id < 0x10000000 ? LuceniaVersion.mask(id) : id);
        if (known != null) {
            return known;
        }
        return (LuceniaVersion)LuceniaVersion.fromIdSlow(id);
    }

    public static int computeID(int major, int minor, int revision, int build) {
        return major * 1000000 + minor * 10000 + revision * 100 + build ^ 0x10000000;
    }

    public static LuceniaVersion fromString(String version) {
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        LuceniaVersion cached = stringToVersion.get(version);
        if (cached != null) {
            return cached;
        }
        return LuceniaVersion.fromStringSlow(version, id -> LuceniaVersion.fromId(LuceniaVersion.mask(id)));
    }

    LuceniaVersion(int id, org.apache.lucene.util.Version luceneVersion) {
        super(LuceniaVersion.mask(id), luceneVersion);
    }

    @Override
    public int compareMajor(Version<?> other) {
        if (other instanceof OpenSearchVersion) {
            return Integer.compare(this.major + 3, other.major);
        }
        if (other instanceof LegacyESVersion) {
            return Integer.compare(9 + this.major, other.major);
        }
        return super.compareMajor(other);
    }

    protected int maskId(int id) {
        return 0x10000000 ^ id;
    }

    @Override
    protected <V extends Version> boolean isMinCompatibleVersionType(V version) {
        return version instanceof OpenSearchVersion || version instanceof LuceniaVersion;
    }

    @Override
    protected Version computeMinIndexCompatVersion() {
        int bwcMajor = this.major == 0 ? 2 : this.major - 1;
        boolean bwcMinor = false;
        if (this.major == 0) {
            return Version.min(this, OpenSearchVersion.fromId(bwcMajor * 1000000 + 0 + 99));
        }
        return Version.min(this, LuceniaVersion.fromId(bwcMajor * 1000000 + 0 + 99));
    }

    @Override
    protected <V extends Version> boolean checkMajorVersionCompatibility(V version) {
        if (version instanceof LegacyESVersion) {
            return false;
        }
        int a = this.major;
        byte b = version.major;
        if (version instanceof OpenSearchVersion && b <= 3) {
            a += 3;
        }
        return Math.max(a, b) - Math.min(a, b) <= 1;
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), System.getProperty("java.version"));
        System.out.println(versionOutput);
    }

    static {
        CURRENT = V_0_8_1 = new LuceniaVersion(80199, org.apache.lucene.util.Version.LUCENE_10_3_1);
        declaredVersions = LuceniaVersion.initializeDeclaredVersions(LuceniaVersion.class);
        Tuple<Map<Integer, LuceniaVersion>, Map<String, LuceniaVersion>> versionMaps = LuceniaVersion.getIdAndStringToVersion(LuceniaVersion.class, Optional.empty(), Optional.empty());
        assert (LuceniaVersion.CURRENT.luceneVersion.equals((Object)org.apache.lucene.util.Version.LATEST)) : "Version must be upgraded to [" + String.valueOf(org.apache.lucene.util.Version.LATEST) + "] is still set to [" + String.valueOf(LuceniaVersion.CURRENT.luceneVersion) + "]";
        idToVersion = (Map)versionMaps.v1();
        stringToVersion = (Map)versionMaps.v2();
    }
}

