/*
 * Decompiled with CFR 0.152.
 */
package io.skylite;

import io.skylite.LegacyESVersion;
import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.Strings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class OpenSearchVersion
extends Version<OpenSearchVersion> {
    public static final OpenSearchVersion V_2_0_0 = new OpenSearchVersion(2000099, org.apache.lucene.util.Version.LUCENE_9_1_0);
    public static final OpenSearchVersion V_2_0_1 = new OpenSearchVersion(2000199, org.apache.lucene.util.Version.LUCENE_9_1_0);
    public static final OpenSearchVersion V_2_1_0 = new OpenSearchVersion(2010099, org.apache.lucene.util.Version.LUCENE_9_2_0);
    public static final OpenSearchVersion V_2_2_0 = new OpenSearchVersion(2020099, org.apache.lucene.util.Version.LUCENE_9_3_0);
    public static final OpenSearchVersion V_2_2_1 = new OpenSearchVersion(2020199, org.apache.lucene.util.Version.LUCENE_9_3_0);
    public static final OpenSearchVersion V_2_3_0 = new OpenSearchVersion(2030099, org.apache.lucene.util.Version.LUCENE_9_3_0);
    public static final OpenSearchVersion V_2_4_0 = new OpenSearchVersion(2040099, org.apache.lucene.util.Version.LUCENE_9_4_1);
    public static final OpenSearchVersion V_2_4_1 = new OpenSearchVersion(2040199, org.apache.lucene.util.Version.LUCENE_9_4_2);
    public static final OpenSearchVersion V_2_5_0 = new OpenSearchVersion(2050099, org.apache.lucene.util.Version.LUCENE_9_4_2);
    public static final OpenSearchVersion V_2_5_1 = new OpenSearchVersion(2050199, org.apache.lucene.util.Version.LUCENE_9_4_2);
    public static final OpenSearchVersion V_2_4_2 = new OpenSearchVersion(2040299, org.apache.lucene.util.Version.LUCENE_9_4_2);
    public static final OpenSearchVersion V_2_6_0 = new OpenSearchVersion(2060099, org.apache.lucene.util.Version.LUCENE_9_5_0);
    public static final OpenSearchVersion V_2_6_1 = new OpenSearchVersion(2060199, org.apache.lucene.util.Version.LUCENE_9_5_0);
    public static final OpenSearchVersion V_2_7_0 = new OpenSearchVersion(2070099, org.apache.lucene.util.Version.LUCENE_9_5_0);
    public static final OpenSearchVersion V_2_7_1 = new OpenSearchVersion(2070199, org.apache.lucene.util.Version.LUCENE_9_5_0);
    public static final OpenSearchVersion V_2_8_0 = new OpenSearchVersion(2080099, org.apache.lucene.util.Version.LUCENE_9_6_0);
    public static final OpenSearchVersion V_2_8_1 = new OpenSearchVersion(2080199, org.apache.lucene.util.Version.LUCENE_9_6_0);
    public static final OpenSearchVersion V_2_9_0 = new OpenSearchVersion(2090099, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final OpenSearchVersion V_2_9_1 = new OpenSearchVersion(2090199, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final OpenSearchVersion V_2_10_0 = new OpenSearchVersion(2100099, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final OpenSearchVersion V_2_10_1 = new OpenSearchVersion(2100199, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final OpenSearchVersion V_2_11_0 = new OpenSearchVersion(2110099, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final OpenSearchVersion V_2_11_1 = new OpenSearchVersion(2110199, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final OpenSearchVersion V_2_11_2 = new OpenSearchVersion(2110299, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final OpenSearchVersion V_2_12_0 = new OpenSearchVersion(2120099, org.apache.lucene.util.Version.LUCENE_9_9_2);
    public static final OpenSearchVersion V_2_12_1 = new OpenSearchVersion(2120199, org.apache.lucene.util.Version.LUCENE_9_9_2);
    public static final OpenSearchVersion V_2_13_0 = new OpenSearchVersion(2130099, org.apache.lucene.util.Version.LUCENE_9_10_0);
    public static final OpenSearchVersion V_2_13_1 = new OpenSearchVersion(2130199, org.apache.lucene.util.Version.LUCENE_9_10_0);
    public static final OpenSearchVersion V_2_14_0 = new OpenSearchVersion(2140099, org.apache.lucene.util.Version.LUCENE_9_10_0);
    public static final OpenSearchVersion V_3_0_0 = new OpenSearchVersion(3000099, org.apache.lucene.util.Version.LUCENE_9_11_0);
    protected static final Map<Integer, OpenSearchVersion> idToVersion;
    protected static final Map<String, OpenSearchVersion> stringToVersion;
    public static final List<OpenSearchVersion> declaredVersions;
    public static final int MASK = 0x8000000;

    protected OpenSearchVersion(int id, org.apache.lucene.util.Version luceneVersion) {
        super(OpenSearchVersion.mask(id), luceneVersion);
    }

    public static int mask(int id) {
        return id ^ 0x8000000;
    }

    private static int unmask(int id) {
        if (id != 0) {
            return (id ^ 0x8000000) & 0xF7FFFFFF;
        }
        return id;
    }

    @Override
    protected Function<Integer, Integer> unmask() {
        return OpenSearchVersion::unmask;
    }

    public static OpenSearchVersion fromId(int id) {
        OpenSearchVersion known = idToVersion.get(id = id < 0x8000000 ? OpenSearchVersion.mask(id) : id);
        if (known != null) {
            return known;
        }
        return (OpenSearchVersion)OpenSearchVersion.fromIdSlow(id);
    }

    public static Version fromString(String version) {
        if (!Strings.hasLength(version)) {
            return declaredVersions.get(declaredVersions.size() - 1);
        }
        OpenSearchVersion cached = stringToVersion.get(version);
        if (cached != null) {
            return cached;
        }
        return OpenSearchVersion.fromStringSlow(version, id -> OpenSearchVersion.fromId(OpenSearchVersion.mask(id)));
    }

    @Override
    public int compareMajor(Version<?> other) {
        if (other instanceof LuceniaVersion) {
            return other.compareMajor(this);
        }
        if (other instanceof LegacyESVersion) {
            return Integer.compare(6 + this.major, other.major);
        }
        return super.compareMajor(other);
    }

    @Override
    protected <V extends Version> boolean checkMajorVersionCompatibility(V version) {
        int a = this.major;
        int b = version.major;
        if (version instanceof LegacyESVersion) {
            if (a == 7 || b == 7 || a == 6 || b == 6) {
                if (this.major <= 2) {
                    a += 6;
                }
                if (version.major <= 2) {
                    b += 6;
                }
            }
        } else if (version instanceof LuceniaVersion) {
            b += 3;
        }
        return Math.max(a, b) - Math.min(a, b) <= 1;
    }

    @Override
    protected <V extends Version> boolean isMinCompatibleVersionType(V version) {
        return version instanceof LegacyESVersion || version instanceof OpenSearchVersion;
    }

    @Override
    protected <V extends Version> V computeMinCompatVersion() {
        if (this.major == 1 || this.major == 7) {
            return (V)LegacyESVersion.fromId(6080099);
        }
        if (this.major == 2) {
            return (V)LegacyESVersion.fromId(7100099);
        }
        return super.computeMinCompatVersion();
    }

    @Override
    protected Version computeMinIndexCompatVersion() {
        if (this.major == 1) {
            return LegacyESVersion.fromId(6000026);
        }
        if (this.major == 2) {
            return LegacyESVersion.fromId(7000099);
        }
        int bwcMajor = this.major - 1;
        boolean bwcMinor = false;
        if (this.major == 3) {
            return Version.min(this, OpenSearchVersion.fromId(bwcMajor * 1000000 + 0 + 99 ^ 0x8000000));
        }
        return Version.min(this, OpenSearchVersion.fromId(bwcMajor * 1000000 + 0 + 99));
    }

    static {
        declaredVersions = OpenSearchVersion.initializeDeclaredVersions(OpenSearchVersion.class);
        Tuple<Map<Integer, OpenSearchVersion>, Map<String, OpenSearchVersion>> versionMaps = OpenSearchVersion.getIdAndStringToVersion(OpenSearchVersion.class, Optional.empty(), Optional.empty());
        idToVersion = (Map)versionMaps.v1();
        stringToVersion = (Map)versionMaps.v2();
    }
}

